"use strict";
var core_1 = require("@angular/core");
var AxisResolverFactory = (function () {
    function AxisResolverFactory() {
    }
    AxisResolverFactory.prototype.create = function (vertical) {
        if (vertical === void 0) { vertical = true; }
        return new AxisResolver(vertical);
    };
    AxisResolverFactory.decorators = [
        { type: core_1.Injectable },
    ];
    /** @nocollapse */
    AxisResolverFactory.ctorParameters = [];
    return AxisResolverFactory;
}());
exports.AxisResolverFactory = AxisResolverFactory;
var AxisResolver = (function () {
    function AxisResolver(vertical) {
        if (vertical === void 0) { vertical = true; }
        this.vertical = vertical;
    }
    AxisResolver.prototype.clientHeightKey = function () { return this.vertical ? 'clientHeight' : 'clientWidth'; };
    AxisResolver.prototype.offsetHeightKey = function () { return this.vertical ? 'offsetHeight' : 'offsetWidth'; };
    AxisResolver.prototype.scrollHeightKey = function () { return this.vertical ? 'scrollHeight' : 'scrollWidth'; };
    AxisResolver.prototype.pageYOffsetKey = function () { return this.vertical ? 'pageYOffset' : 'pageXOffset'; };
    AxisResolver.prototype.offsetTopKey = function () { return this.vertical ? 'offsetTop' : 'offsetLeft'; };
    AxisResolver.prototype.scrollTopKey = function () { return this.vertical ? 'scrollTop' : 'scrollLeft'; };
    AxisResolver.prototype.topKey = function () { return this.vertical ? 'top' : 'left'; };
    return AxisResolver;
}());
exports.AxisResolver = AxisResolver;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiYXhpcy1yZXNvbHZlci5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbImF4aXMtcmVzb2x2ZXIudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IjtBQUFBLHFCQUFtQyxlQUFlLENBQUMsQ0FBQTtBQUduRDtJQUNFO0lBQWUsQ0FBQztJQUVoQixvQ0FBTSxHQUFOLFVBQVEsUUFBd0I7UUFBeEIsd0JBQXdCLEdBQXhCLGVBQXdCO1FBQzlCLE1BQU0sQ0FBQyxJQUFJLFlBQVksQ0FBQyxRQUFRLENBQUMsQ0FBQztJQUNwQyxDQUFDO0lBQ0ksOEJBQVUsR0FBMEI7UUFDM0MsRUFBRSxJQUFJLEVBQUUsaUJBQVUsRUFBRTtLQUNuQixDQUFDO0lBQ0Ysa0JBQWtCO0lBQ1gsa0NBQWMsR0FBNkQsRUFDakYsQ0FBQztJQUNGLDBCQUFDO0FBQUQsQ0FBQyxBQVpELElBWUM7QUFaWSwyQkFBbUIsc0JBWS9CLENBQUE7QUFFRDtJQUNFLHNCQUFxQixRQUF3QjtRQUFoQyx3QkFBZ0MsR0FBaEMsZUFBZ0M7UUFBeEIsYUFBUSxHQUFSLFFBQVEsQ0FBZ0I7SUFDN0MsQ0FBQztJQUNELHNDQUFlLEdBQWYsY0FBbUIsTUFBTSxDQUFDLElBQUksQ0FBQyxRQUFRLEdBQUcsY0FBYyxHQUFHLGFBQWEsQ0FBQSxDQUFBLENBQUM7SUFDekUsc0NBQWUsR0FBZixjQUFtQixNQUFNLENBQUMsSUFBSSxDQUFDLFFBQVEsR0FBRyxjQUFjLEdBQUcsYUFBYSxDQUFBLENBQUEsQ0FBQztJQUN6RSxzQ0FBZSxHQUFmLGNBQW1CLE1BQU0sQ0FBQyxJQUFJLENBQUMsUUFBUSxHQUFHLGNBQWMsR0FBRyxhQUFhLENBQUEsQ0FBQSxDQUFDO0lBQ3pFLHFDQUFjLEdBQWQsY0FBbUIsTUFBTSxDQUFDLElBQUksQ0FBQyxRQUFRLEdBQUcsYUFBYSxHQUFJLGFBQWEsQ0FBQSxDQUFBLENBQUM7SUFDekUsbUNBQVksR0FBWixjQUFtQixNQUFNLENBQUMsSUFBSSxDQUFDLFFBQVEsR0FBRyxXQUFXLEdBQU0sWUFBWSxDQUFBLENBQUEsQ0FBQztJQUN4RSxtQ0FBWSxHQUFaLGNBQW1CLE1BQU0sQ0FBQyxJQUFJLENBQUMsUUFBUSxHQUFHLFdBQVcsR0FBTSxZQUFZLENBQUEsQ0FBQSxDQUFDO0lBQ3hFLDZCQUFNLEdBQU4sY0FBbUIsTUFBTSxDQUFDLElBQUksQ0FBQyxRQUFRLEdBQUcsS0FBSyxHQUFZLE1BQU0sQ0FBQSxDQUFBLENBQUM7SUFDcEUsbUJBQUM7QUFBRCxDQUFDLEFBVkQsSUFVQztBQVZZLG9CQUFZLGVBVXhCLENBQUEiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgeyBJbmplY3RhYmxlLCBJbmplY3QgfSBmcm9tIFwiQGFuZ3VsYXIvY29yZVwiO1xuXG5cbmV4cG9ydCBjbGFzcyBBeGlzUmVzb2x2ZXJGYWN0b3J5IHtcbiAgY29uc3RydWN0b3IoKSB7fVxuXG4gIGNyZWF0ZSAodmVydGljYWw6IGJvb2xlYW4gPSB0cnVlKSB7XG4gICAgcmV0dXJuIG5ldyBBeGlzUmVzb2x2ZXIodmVydGljYWwpO1xuICB9XG5zdGF0aWMgZGVjb3JhdG9yczogRGVjb3JhdG9ySW52b2NhdGlvbltdID0gW1xueyB0eXBlOiBJbmplY3RhYmxlIH0sXG5dO1xuLyoqIEBub2NvbGxhcHNlICovXG5zdGF0aWMgY3RvclBhcmFtZXRlcnM6ICh7dHlwZTogYW55LCBkZWNvcmF0b3JzPzogRGVjb3JhdG9ySW52b2NhdGlvbltdfXxudWxsKVtdID0gW1xuXTtcbn1cblxuZXhwb3J0IGNsYXNzIEF4aXNSZXNvbHZlciB7XG4gIGNvbnN0cnVjdG9yIChwcml2YXRlIHZlcnRpY2FsOiBib29sZWFuID0gdHJ1ZSkge1xuICB9XG4gIGNsaWVudEhlaWdodEtleSgpIHtyZXR1cm4gdGhpcy52ZXJ0aWNhbCA/ICdjbGllbnRIZWlnaHQnIDogJ2NsaWVudFdpZHRoJ31cbiAgb2Zmc2V0SGVpZ2h0S2V5KCkge3JldHVybiB0aGlzLnZlcnRpY2FsID8gJ29mZnNldEhlaWdodCcgOiAnb2Zmc2V0V2lkdGgnfVxuICBzY3JvbGxIZWlnaHRLZXkoKSB7cmV0dXJuIHRoaXMudmVydGljYWwgPyAnc2Nyb2xsSGVpZ2h0JyA6ICdzY3JvbGxXaWR0aCd9XG4gIHBhZ2VZT2Zmc2V0S2V5KCkgIHtyZXR1cm4gdGhpcy52ZXJ0aWNhbCA/ICdwYWdlWU9mZnNldCcgIDogJ3BhZ2VYT2Zmc2V0J31cbiAgb2Zmc2V0VG9wS2V5KCkgICAge3JldHVybiB0aGlzLnZlcnRpY2FsID8gJ29mZnNldFRvcCcgICAgOiAnb2Zmc2V0TGVmdCd9XG4gIHNjcm9sbFRvcEtleSgpICAgIHtyZXR1cm4gdGhpcy52ZXJ0aWNhbCA/ICdzY3JvbGxUb3AnICAgIDogJ3Njcm9sbExlZnQnfVxuICB0b3BLZXkoKSAgICAgICAgICB7cmV0dXJuIHRoaXMudmVydGljYWwgPyAndG9wJyAgICAgICAgICA6ICdsZWZ0J31cbn1cbmludGVyZmFjZSBEZWNvcmF0b3JJbnZvY2F0aW9uIHtcbiAgdHlwZTogRnVuY3Rpb247XG4gIGFyZ3M/OiBhbnlbXTtcbn1cbiJdfQ==