import { ElementRef, EventEmitter, OnDestroy, OnInit, OnChanges, SimpleChanges, NgZone } from '@angular/core';
import { Scroller, InfiniteScrollEvent } from './scroller';
import { PositionResolverFactory } from './position-resolver';
export declare class InfiniteScroll implements OnDestroy, OnInit, OnChanges {
    private element;
    private zone;
    private positionResolverFactory;
    scroller: Scroller;
    _distanceDown: number;
    _distanceUp: number;
    _throttle: number;
    _disabled: boolean;
    scrollWindow: boolean;
    _immediate: boolean;
    _horizontal: boolean;
    _alwaysCallback: boolean;
    scrolled: EventEmitter<InfiniteScrollEvent>;
    scrolledUp: EventEmitter<InfiniteScrollEvent>;
    constructor(element: ElementRef, zone: NgZone, positionResolverFactory: PositionResolverFactory);
    ngOnInit(): void;
    ngOnDestroy(): void;
    ngOnChanges(changes: SimpleChanges): void;
    onScrollDown(data?: InfiniteScrollEvent): void;
    onScrollUp(data?: InfiniteScrollEvent): void;
}
