"use strict";
var core_1 = require('@angular/core');
var scroller_1 = require('./scroller');
var position_resolver_1 = require('./position-resolver');
var InfiniteScroll = (function () {
    function InfiniteScroll(element, zone, positionResolverFactory) {
        this.element = element;
        this.zone = zone;
        this.positionResolverFactory = positionResolverFactory;
        this._distanceDown = 2;
        this._distanceUp = 1.5;
        this._throttle = 300;
        this._disabled = false;
        this.scrollWindow = true;
        this._immediate = false;
        this._horizontal = false;
        this._alwaysCallback = false;
        this.scrolled = new core_1.EventEmitter();
        this.scrolledUp = new core_1.EventEmitter();
    }
    InfiniteScroll.prototype.ngOnInit = function () {
        if (typeof window !== 'undefined') {
            var containerElement = this.scrollWindow ? window : this.element;
            this.scroller = new scroller_1.Scroller(containerElement, setInterval, this.element, this.onScrollDown.bind(this), this.onScrollUp.bind(this), this._distanceDown, this._distanceUp, {}, this._throttle, this._immediate, this._horizontal, this._alwaysCallback, this._disabled, this.positionResolverFactory);
        }
    };
    InfiniteScroll.prototype.ngOnDestroy = function () {
        if (this.scroller) {
            this.scroller.clean();
        }
    };
    InfiniteScroll.prototype.ngOnChanges = function (changes) {
        if (changes['_disabled'] && this.scroller) {
            this.scroller.handleInfiniteScrollDisabled(changes['_disabled'].currentValue);
        }
    };
    InfiniteScroll.prototype.onScrollDown = function (data) {
        var _this = this;
        if (data === void 0) { data = { currentScrollPosition: 0 }; }
        this.zone.run(function () { return _this.scrolled.next(data); });
    };
    InfiniteScroll.prototype.onScrollUp = function (data) {
        var _this = this;
        if (data === void 0) { data = { currentScrollPosition: 0 }; }
        this.zone.run(function () { return _this.scrolledUp.next(data); });
    };
    InfiniteScroll.decorators = [
        { type: core_1.Directive, args: [{
                    selector: '[infinite-scroll]'
                },] },
    ];
    /** @nocollapse */
    InfiniteScroll.ctorParameters = [
        { type: core_1.ElementRef, },
        { type: core_1.NgZone, },
        { type: position_resolver_1.PositionResolverFactory, },
    ];
    InfiniteScroll.propDecorators = {
        '_distanceDown': [{ type: core_1.Input, args: ['infiniteScrollDistance',] },],
        '_distanceUp': [{ type: core_1.Input, args: ['infiniteScrollUpDistance',] },],
        '_throttle': [{ type: core_1.Input, args: ['infiniteScrollThrottle',] },],
        '_disabled': [{ type: core_1.Input, args: ['infiniteScrollDisabled',] },],
        'scrollWindow': [{ type: core_1.Input, args: ['scrollWindow',] },],
        '_immediate': [{ type: core_1.Input, args: ['immediateCheck',] },],
        '_horizontal': [{ type: core_1.Input, args: ['horizontal',] },],
        '_alwaysCallback': [{ type: core_1.Input, args: ['alwaysCallback',] },],
        'scrolled': [{ type: core_1.Output },],
        'scrolledUp': [{ type: core_1.Output },],
    };
    return InfiniteScroll;
}());
exports.InfiniteScroll = InfiniteScroll;
//# sourceMappingURL=data:application/json;base64,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