"use strict";
var infinite_scroll_1 = require('./infinite-scroll');
var axis_resolver_1 = require('./axis-resolver');
var position_resolver_1 = require('./position-resolver');
var core_1 = require('@angular/core');
describe('Infinite Scroll Directive', function () {
    // const zone = new NgZone({ enableLongStackTrace: false });
    var zone = jasmine.createSpyObj('zone', ['run']);
    var createMockElement = function () {
        var mockedElement = new core_1.ElementRef(document.createElement('div'));
        return mockedElement;
    };
    var positionResolver;
    var createInfiniteScroll = function () {
        var mockedElement = createMockElement();
        var axis = new axis_resolver_1.AxisResolverFactory();
        positionResolver = new position_resolver_1.PositionResolverFactory(axis);
        return new infinite_scroll_1.InfiniteScroll(mockedElement, zone, positionResolver);
    };
    beforeEach(function () {
    });
    it('should create an instance of the directive', function () {
        var actual = createInfiniteScroll();
        expect(actual).toBeDefined();
    });
    it('should have default @Input properties values', function () {
        var directive = createInfiniteScroll();
        var expectedInputs = {
            _distanceDown: 2,
            _distanceUp: 1.5,
            _throttle: 300,
            scrollWindow: true,
            _immediate: false,
            _horizontal: false,
            _alwaysCallback: false,
            _disabled: false
        };
        Object.keys(expectedInputs).forEach(function (input) {
            return expect(directive[input]).toEqual(expectedInputs[input]);
        });
    });
    it('should trigger the onScrollDown event when scroll has passed _distandDown', function () {
        var directive = createInfiniteScroll();
        spyOn(directive, 'onScrollDown');
        directive.ngOnInit();
        directive.scroller.handler();
        expect(directive.onScrollDown).toHaveBeenCalled();
    });
    it('should trigger the onScrollUp event when scroll has passed _distanceUp', function () {
        var directive = createInfiniteScroll();
        spyOn(directive, 'onScrollUp');
        directive.ngOnInit();
        directive.scroller.lastScrollPosition = 350;
        directive.scroller.handler();
        expect(directive.onScrollUp).toHaveBeenCalled();
    });
    it('should disable the scroller', function () {
        var directive = createInfiniteScroll();
        var changes = {
            '_disabled': new core_1.SimpleChange(false, true)
        };
        // spyOn(directive, 'onScrollUp');
        directive.ngOnInit();
        directive.ngOnChanges(changes);
        var expected = false;
        var actual = directive.scroller.scrollEnabled;
        expect(actual).toBe(expected);
    });
});
//# sourceMappingURL=data:application/json;base64,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