import { ElementRef } from '@angular/core';
import { AxisResolver, AxisResolverFactory } from './axis-resolver';
export interface PositionElements {
    container: ElementRef;
    documentElement: any;
    isContainerWindow: boolean;
    horizontal: boolean;
}
export declare class PositionResolverFactory {
    private axisResolver;
    constructor(axisResolver: AxisResolverFactory);
    create(options: PositionElements): PositionResolver;
}
export declare class PositionResolver {
    private axis;
    private options;
    constructor(axis: AxisResolver, options: PositionElements);
    calculatePoints(element: ElementRef): {
        height: any;
        scrolledUntilNow: any;
        totalToScroll: any;
    };
    calculatePointsForWindow(element: ElementRef): {
        height: any;
        scrolledUntilNow: any;
        totalToScroll: any;
    };
    calculatePointsForElement(element: ElementRef): {
        height: any;
        scrolledUntilNow: any;
        totalToScroll: any;
    };
    private height(elem);
    private offsetTop(elem);
    pageYOffset(elem: any): any;
}
