"use strict";
var core_1 = require('@angular/core');
var axis_resolver_1 = require('./axis-resolver');
var PositionResolverFactory = (function () {
    function PositionResolverFactory(axisResolver) {
        this.axisResolver = axisResolver;
    }
    PositionResolverFactory.prototype.create = function (options) {
        return new PositionResolver(this.axisResolver.create(!options.horizontal), options);
    };
    PositionResolverFactory.decorators = [
        { type: core_1.Injectable },
    ];
    /** @nocollapse */
    PositionResolverFactory.ctorParameters = [
        { type: axis_resolver_1.AxisResolverFactory, },
    ];
    return PositionResolverFactory;
}());
exports.PositionResolverFactory = PositionResolverFactory;
var PositionResolver = (function () {
    function PositionResolver(axis, options) {
        this.axis = axis;
        this.options = options;
    }
    PositionResolver.prototype.calculatePoints = function (element) {
        return this.options.isContainerWindow
            ? this.calculatePointsForWindow(element)
            : this.calculatePointsForElement(element);
    };
    PositionResolver.prototype.calculatePointsForWindow = function (element) {
        // container's height
        var height = this.height(this.options.container);
        // scrolled until now / current y point
        var scrolledUntilNow = height + this.pageYOffset(this.options.documentElement);
        // total height / most bottom y point
        var totalToScroll = this.offsetTop(element.nativeElement) + this.height(element.nativeElement);
        return { height: height, scrolledUntilNow: scrolledUntilNow, totalToScroll: totalToScroll };
    };
    PositionResolver.prototype.calculatePointsForElement = function (element) {
        var scrollTop = this.axis.scrollTopKey();
        var scrollHeight = this.axis.scrollHeightKey();
        var height = this.height(this.options.container);
        // perhaps use this.container.offsetTop instead of 'scrollTop'
        var scrolledUntilNow = this.options.container[scrollTop];
        var containerTopOffset = 0;
        var offsetTop = this.offsetTop(this.options.container);
        if (offsetTop !== void 0) {
            containerTopOffset = offsetTop;
        }
        var totalToScroll = this.options.container[scrollHeight];
        // const totalToScroll = this.offsetTop(this.$elementRef.nativeElement) - containerTopOffset + this.height(this.$elementRef.nativeElement);
        return { height: height, scrolledUntilNow: scrolledUntilNow, totalToScroll: totalToScroll };
    };
    PositionResolver.prototype.height = function (elem) {
        var offsetHeight = this.axis.offsetHeightKey();
        var clientHeight = this.axis.clientHeightKey();
        // elem = elem.nativeElement;
        if (isNaN(elem[offsetHeight])) {
            return this.options.documentElement[clientHeight];
        }
        else {
            return elem[offsetHeight];
        }
    };
    PositionResolver.prototype.offsetTop = function (elem) {
        var top = this.axis.topKey();
        // elem = elem.nativeElement;
        if (!elem.getBoundingClientRect) {
            return;
        }
        return elem.getBoundingClientRect()[top] + this.pageYOffset(elem);
    };
    PositionResolver.prototype.pageYOffset = function (elem) {
        var pageYOffset = this.axis.pageYOffsetKey();
        var scrollTop = this.axis.scrollTopKey();
        var offsetTop = this.axis.offsetTopKey();
        // elem = elem.nativeElement;
        if (isNaN(window[pageYOffset])) {
            return this.options.documentElement[scrollTop];
        }
        else if (elem.ownerDocument) {
            return elem.ownerDocument.defaultView[pageYOffset];
        }
        else {
            return elem[offsetTop];
        }
    };
    return PositionResolver;
}());
exports.PositionResolver = PositionResolver;
//# sourceMappingURL=data:application/json;base64,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