"use strict";
var Observable_1 = require('rxjs/Observable');
require('rxjs/add/observable/fromEvent');
require('rxjs/add/observable/timer');
require('rxjs/add/operator/throttle');
require('rxjs/add/operator/filter');
require('rxjs/add/operator/delay');
;
var Scroller = (function () {
    function Scroller(windowElement, $interval, $elementRef, infiniteScrollDownCallback, infiniteScrollUpCallback, infiniteScrollDownDistance, infiniteScrollUpDistance, infiniteScrollParent, infiniteScrollThrottle, isImmediate, horizontal, alwaysCallback, scrollDisabled, _positionResolver) {
        if (horizontal === void 0) { horizontal = false; }
        if (alwaysCallback === void 0) { alwaysCallback = false; }
        if (scrollDisabled === void 0) { scrollDisabled = false; }
        this.windowElement = windowElement;
        this.$interval = $interval;
        this.$elementRef = $elementRef;
        this.infiniteScrollDownCallback = infiniteScrollDownCallback;
        this.infiniteScrollUpCallback = infiniteScrollUpCallback;
        this.infiniteScrollThrottle = infiniteScrollThrottle;
        this.isImmediate = isImmediate;
        this.horizontal = horizontal;
        this.alwaysCallback = alwaysCallback;
        this.scrollDisabled = scrollDisabled;
        this._positionResolver = _positionResolver;
        this.lastScrollPosition = 0;
        this.isContainerWindow = Object.prototype.toString.call(this.windowElement).includes('Window');
        this.documentElement = this.isContainerWindow ? this.windowElement.document.documentElement : null;
        this.handleInfiniteScrollDistance(infiniteScrollDownDistance, infiniteScrollUpDistance);
        // if (attrs.infiniteScrollParent != null) {
        // 	attachEvent(angular.element(elem.parent()));
        // }
        this.handleInfiniteScrollDisabled(scrollDisabled);
        this.defineContainer();
        this.positionResolver = this._positionResolver.create({
            container: this.container,
            documentElement: this.documentElement,
            isContainerWindow: this.isContainerWindow,
            horizontal: horizontal
        });
        this.createInterval();
    }
    Scroller.prototype.defineContainer = function () {
        if (this.isContainerWindow) {
            this.container = this.windowElement;
        }
        else {
            this.container = this.windowElement.nativeElement;
        }
        this.attachEvent(this.container);
    };
    Scroller.prototype.createInterval = function () {
        var _this = this;
        if (this.isImmediate) {
            this.checkInterval = this.$interval(function () {
                return _this.handler();
            }, 0);
        }
    };
    Scroller.prototype.handler = function () {
        var _this = this;
        var container = this.positionResolver.calculatePoints(this.$elementRef);
        var scrollingDown = this.lastScrollPosition < container.scrolledUntilNow;
        this.lastScrollPosition = container.scrolledUntilNow;
        var remaining;
        var containerBreakpoint;
        if (scrollingDown) {
            remaining = container.totalToScroll - container.scrolledUntilNow;
            containerBreakpoint = container.height * this.scrollDownDistance + 1;
        }
        else {
            remaining = container.scrolledUntilNow;
            containerBreakpoint = container.height * this.scrollUpDistance + 1;
        }
        var shouldScroll = remaining <= containerBreakpoint;
        var triggerCallback = (this.alwaysCallback || shouldScroll) && this.scrollEnabled;
        var shouldClearInterval = !shouldScroll && this.checkInterval;
        // if (this.useDocumentBottom) {
        // 	container.totalToScroll = this.height(this.$elementRef.nativeElement.ownerDocument);
        // }
        this.checkWhenEnabled = shouldScroll;
        if (triggerCallback) {
            var infiniteScrollEvent = {
                currentScrollPosition: container.scrolledUntilNow
            };
            if (scrollingDown) {
                this.infiniteScrollDownCallback(infiniteScrollEvent);
            }
            else {
                this.infiniteScrollUpCallback(infiniteScrollEvent);
            }
        }
        if (shouldClearInterval) {
            clearInterval(this.checkInterval);
        }
        setTimeout(function () {
            var container = _this.positionResolver.calculatePoints(_this.$elementRef);
            if (container.scrolledUntilNow >= container.totalToScroll) {
                _this.handler();
            }
        }, this.infiniteScrollThrottle);
    };
    Scroller.prototype.handleInfiniteScrollDistance = function (scrollDownDistance, scrollUpDistance) {
        this.scrollDownDistance = parseFloat(scrollDownDistance) || 0;
        this.scrollUpDistance = parseFloat(scrollUpDistance) || 0;
    };
    Scroller.prototype.attachEvent = function (newContainer) {
        var _this = this;
        this.clean();
        if (newContainer) {
            var throttle_1 = this.infiniteScrollThrottle;
            this.disposeScroll = Observable_1.Observable.fromEvent(this.container, 'scroll')
                .throttle(function (ev) { return Observable_1.Observable.timer(throttle_1); })
                .filter(function (ev) { return _this.scrollEnabled; })
                .subscribe(function (ev) { return _this.handler(); });
        }
    };
    Scroller.prototype.clean = function () {
        if (this.disposeScroll) {
            this.disposeScroll.unsubscribe();
        }
    };
    Scroller.prototype.handleInfiniteScrollDisabled = function (scrollDisabled) {
        this.scrollEnabled = !scrollDisabled;
    };
    return Scroller;
}());
exports.Scroller = Scroller;
//# sourceMappingURL=data:application/json;base64,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