"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var core_1 = require('@angular/core');
var common_1 = require('@angular/common');
var lodash_1 = require('lodash');
var CurrencyMaskDirective = (function () {
    function CurrencyMaskDirective(model) {
        this.currency = '$';
        this.digitPattern = /\d\.?/g;
        this.model = model;
        console.log(model);
    }
    CurrencyMaskDirective.prototype.onInputChange = function () {
        var currentValue = this.model.value;
        var actualValue = this.getActualValue(currentValue);
        var maskedValue = this.getMaskedValue(actualValue);
        // This is the actual binding (unmasked) value
        this.model.viewToModelUpdate(actualValue);
        // This is the displaying (masked) value
        this.model.valueAccessor.writeValue(maskedValue);
    };
    // Returns the actual (unmasked) value
    CurrencyMaskDirective.prototype.getActualValue = function (currentValue) {
        var result = '';
        // Check if something is available to mask
        if (currentValue && currentValue.length > 0) {
            // Check if the entered value is a negative
            if (currentValue.indexOf('-') > -1) {
                result += '-';
            }
            var digits = currentValue.match(this.digitPattern);
            lodash_1.forEach(digits, function (value) {
                result += value;
            });
        }
        return result;
    };
    // Returns the masked value
    CurrencyMaskDirective.prototype.getMaskedValue = function (actualValue) {
        var result = null;
        if (actualValue) {
            result = this.currency + actualValue;
        }
        return result;
    };
    CurrencyMaskDirective = __decorate([
        core_1.Directive({
            selector: '[currency-mask]',
            host: {
                '(keyup)': 'onInputChange()'
            }
        }), 
        __metadata('design:paramtypes', [common_1.NgControl])
    ], CurrencyMaskDirective);
    return CurrencyMaskDirective;
}());
exports.CurrencyMaskDirective = CurrencyMaskDirective;
