import { Http, Request, RequestOptionsArgs, Response } from 'angular2/http';
import { Observable } from 'rxjs/Observable';
export interface IAuthConfig {
    headerName: string;
    headerPrefix: string;
    tokenName: string;
    tokenGetter: any;
    noJwtError: boolean;
}
/**
 * Sets up the authentication configuration.
 */
export declare class AuthConfig {
    config: any;
    headerName: string;
    headerPrefix: string;
    tokenName: string;
    tokenGetter: any;
    noJwtError: boolean;
    constructor(config?: any);
    getConfig(): {
        headerName: string;
        headerPrefix: string;
        tokenName: string;
        tokenGetter: any;
        noJwtError: boolean;
    };
}
/**
 * Allows for explicit authenticated HTTP requests.
 */
export declare class AuthHttp {
    private http;
    private _config;
    tokenStream: Observable<string>;
    constructor(options: AuthConfig, http: Http);
    _request(url: string | Request, options?: RequestOptionsArgs): Observable<Response>;
    private requestHelper(requestArgs, additionalOptions);
    get(url: string, options?: RequestOptionsArgs): Observable<Response>;
    post(url: string, body: string, options?: RequestOptionsArgs): Observable<Response>;
    put(url: string, body: string, options?: RequestOptionsArgs): Observable<Response>;
    delete(url: string, options?: RequestOptionsArgs): Observable<Response>;
    patch(url: string, body: string, options?: RequestOptionsArgs): Observable<Response>;
    head(url: string, options?: RequestOptionsArgs): Observable<Response>;
}
/**
 * Helper class to decode and find JWT expiration.
 */
export declare class JwtHelper {
    urlBase64Decode(str: string): string;
    decodeToken(token: string): any;
    getTokenExpirationDate(token: string): Date;
    isTokenExpired(token: string, offsetSeconds?: number): boolean;
}
/**
 * Checks for presence of token and that token hasn't expired.
 * For use with the @CanActivate router decorator and NgIf
 */
export declare function tokenNotExpired(tokenName?: string, jwt?: string): boolean;
