var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var core_1 = require('angular2/core');
var lang_1 = require('angular2/src/facade/lang');
/*

<md-card> is a basic content container component that adds the styles of a material design card.

While you can use this component alone,
it also provides a number of preset styles for common card sections, including:
 - md-card-title
 - md-card-subtitle
 - md-card-content
 - md-card-actions
 - md-card-footer

 You can see some examples of cards here:
 http://embed.plnkr.co/s5O4YcyvbLhIApSrIhtj/

 TODO(kara): update link to demo site when it exists

*/
var MdCard = (function () {
    function MdCard() {
    }
    MdCard = __decorate([
        core_1.Component({
            selector: 'md-card',
            template: `
              <div class="md-card">
                <ng-content></ng-content>
              </div>
            `,
            styles: [`
              md-card {
                display: block;
                position: relative;
                padding: 24px;
                border-radius: 2px;
                box-shadow: 0 2px 5px 0 rgba(0, 0, 0, 0.26);
                font-family: Roboto, "Helvetica Neue", sans-serif;
                background: white; }

              md-card:hover {
                box-shadow: 0 4px 8px 0 rgba(0, 0, 0, 0.4);
                transition: all 0.3s cubic-bezier(0.55, 0, 0.55, 0.2); }

              .md-card-flat {
                box-shadow: none; }

              md-card-title, md-card-subtitle, md-card-content, md-card-actions {
                display: block;
                margin-bottom: 16px; }

              md-card-title {
                font-size: 24px;
                font-weight: 400; }

              md-card-subtitle {
                font-size: 14px;
                color: rgba(0, 0, 0, 0.54); }

              md-card-content {
                font-size: 14px; }

              md-card-actions {
                margin-left: -16px;
                margin-right: -16px;
                padding: 8px 0; }

              [md-card-image] {
                width: calc(100% + 48px);
                margin: 0 -24px 16px -24px; }

              [md-card-xl-image] {
                width: 240px;
                height: 240px;
                margin: -8px; }

              md-card-footer {
                position: absolute;
                bottom: 0; }

              md-card-actions [md-button], md-card-actions [md-raised-button] {
                margin: 0 4px; }

              /* HEADER STYLES */
              md-card-header {
                display: -webkit-flex;
                display: flex;
                -webkit-flex-direction: row;
                        flex-direction: row;
                height: 40px;
                margin: -8px 0 16px 0; }

              .md-card-header-text {
                height: 40px;
                margin: 0 8px; }

              [md-card-avatar] {
                height: 40px;
                width: 40px;
                border-radius: 50%; }

              md-card-header md-card-title {
                font-size: 14px; }

              /* TITLE-GROUP STYLES */
              [md-card-sm-image], [md-card-md-image], [md-card-lg-image] {
                margin: -8px 0; }

              md-card-title-group {
                display: -webkit-flex;
                display: flex;
                -webkit-justify-content: space-between;
                        justify-content: space-between;
                margin: 0 -8px; }

              [md-card-sm-image] {
                width: 80px;
                height: 80px; }

              [md-card-md-image] {
                width: 112px;
                height: 112px; }

              [md-card-lg-image] {
                width: 152px;
                height: 152px; }

              /* MEDIA QUERIES */
              @media (max-width: 600px) {
                md-card {
                  padding: 24px 16px; }
                [md-card-image] {
                  width: calc(100% + 32px);
                  margin: 16px -16px; }
                md-card-title-group {
                  margin: 0; }
                [md-card-xl-image] {
                  margin-left: 0;
                  margin-right: 0; }
                md-card-header {
                  margin: -8px 0 0 0; } }

              /* FIRST/LAST CHILD ADJUSTMENTS */
              .md-card > :first-child, md-card-content > :first-child {
                margin-top: 0; }

              .md-card > :last-child, md-card-content > :last-child {
                margin-bottom: 0; }

              [md-card-image]:first-child {
                margin-top: -24px; }

              .md-card > md-card-actions:last-child {
                margin-bottom: -16px;
                padding-bottom: 0; }

              md-card-actions [md-button]:first-child,
              md-card-actions [md-raised-button]:first-child {
                margin-left: 0;
                margin-right: 0; }

              md-card-title:not(:first-child), md-card-subtitle:not(:first-child) {
                margin-top: -4px; }

              md-card-header md-card-subtitle:not(:first-child) {
                margin-top: -8px; }

              .md-card > [md-card-xl-image]:first-child {
                margin-top: -8px; }

              .md-card > [md-card-xl-image]:last-child {
                margin-bottom: -8px; }
            `],
            encapsulation: core_1.ViewEncapsulation.None,
            changeDetection: core_1.ChangeDetectionStrategy.OnPush,
        }), 
        __metadata('design:paramtypes', [])
    ], MdCard);
    return MdCard;
})();
exports.MdCard = MdCard;
/*  The following components don't have any behavior.
 They simply use content projection to wrap user content
 for flex layout purposes in <md-card> (and thus allow a cleaner, boilerplate-free API).


<md-card-header> is a component intended to be used within the <md-card> component.
It adds styles for a preset header section (i.e. a title, subtitle, and avatar layout).

You can see an example of a card with a header here:
http://embed.plnkr.co/tvJl19z3gZTQd6WmwkIa/

TODO(kara): update link to demo site when it exists
*/
var MdCardHeader = (function () {
    function MdCardHeader() {
    }
    MdCardHeader = __decorate([
        core_1.Component({
            selector: 'md-card-header',
            template: `
              <ng-content select="[md-card-avatar]"></ng-content>
              <div class="md-card-header-text">
                <ng-content select="md-card-title, md-card-subtitle"></ng-content>
              </div>
              <ng-content></ng-content>
            `,
            encapsulation: core_1.ViewEncapsulation.None,
            changeDetection: core_1.ChangeDetectionStrategy.OnPush,
        }), 
        __metadata('design:paramtypes', [])
    ], MdCardHeader);
    return MdCardHeader;
})();
exports.MdCardHeader = MdCardHeader;
/*

<md-card-title-group> is a component intended to be used within the <md-card> component.
It adds styles for a preset layout that groups an image with a title section.

You can see an example of a card with a title-group section here:
http://embed.plnkr.co/EDfgCF9eKcXjini1WODm/

TODO(kara): update link to demo site when it exists
*/
var MdCardTitleGroup = (function () {
    function MdCardTitleGroup() {
    }
    MdCardTitleGroup = __decorate([
        core_1.Component({
            selector: 'md-card-title-group',
            template: `
              <div>
                <ng-content select="md-card-title, md-card-subtitle"></ng-content>
              </div>
              <ng-content select="img"></ng-content>
              <ng-content></ng-content>
            `,
            encapsulation: core_1.ViewEncapsulation.None,
            changeDetection: core_1.ChangeDetectionStrategy.OnPush,
        }), 
        __metadata('design:paramtypes', [])
    ], MdCardTitleGroup);
    return MdCardTitleGroup;
})();
exports.MdCardTitleGroup = MdCardTitleGroup;
exports.MD_CARD_DIRECTIVES = lang_1.CONST_EXPR([MdCard, MdCardHeader, MdCardTitleGroup]);
//# sourceMappingURL=../../../../components/card/card.js.map