"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var core_1 = require('angular2/core');
/**
 * Represents the modal footer for storing buttons.
 */
var ModalFooter = (function () {
    function ModalFooter() {
        /**
         * Emitted when a button was clicked
         * @type {EventEmitter<FooterButtonClickEvent>}
         */
        this.onButtonClick = new core_1.EventEmitter();
    }
    ModalFooter.prototype.onClick = function (btn, $event) {
        this.onButtonClick.emit({ btn: btn, $event: $event });
    };
    __decorate([
        core_1.Input(), 
        __metadata('design:type', String)
    ], ModalFooter.prototype, "footerClass", void 0);
    __decorate([
        core_1.Input(), 
        __metadata('design:type', Array)
    ], ModalFooter.prototype, "buttons", void 0);
    __decorate([
        core_1.Output(), 
        __metadata('design:type', Object)
    ], ModalFooter.prototype, "onButtonClick", void 0);
    ModalFooter = __decorate([
        core_1.Component({
            selector: 'modal-footer',
            template: "<div [ngClass]=\"footerClass\">\n    <button *ngFor=\"#btn of buttons;\"\n            [ngClass]=\"btn.cssClass\"\n            (click)=\"onClick(btn, $event)\">{{btn.caption}}</button>\n</div>"
        }), 
        __metadata('design:paramtypes', [])
    ], ModalFooter);
    return ModalFooter;
}());
exports.ModalFooter = ModalFooter;
//# sourceMappingURL=data:application/json;base64,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