/**
 * Represent a fluent API factory wrapper for defining ConfigBuilder instances.
 */
export declare class ConfigBuilderFactory<T> {
    private _configBuilder;
    constructor(configBuilder?: ConfigBuilder<T>);
    /**
     * Create a setter on the configuration object.
     * @param name The name of the setter function.
     * @param defaultValue If set (not undefined) set's the value on the config object immediately.
     * @returns {ConfigBuilderFactory}
     */
    setMethod(name: string, defaultValue?: any): ConfigBuilderFactory<T>;
    /**
     * The config builder object.
     * @returns {FluentAssign<T>}
     */
    configBuilder: ConfigBuilder<T>;
}
/**
 * Represent a fluent API configuration builder where setter functions return their context
 * which is the ConfigBuilder instance itself.
 */
export declare class ConfigBuilder<T> {
    /**
     *
     * @param defaultConfigValues An object representing default values for the config object.
     * Keys are the config properties and the values are the default values for the config.
     * @param initialSetters A list of initial setters for this ConfigBuilder.
     */
    constructor(defaultConfigValues?: T, initialSetters?: string[]);
    /**
     * Returns a ConfigBuilderFactory ready to define a ConfigBuilder instance.
     * @param defaultConfigValues An object representing default values for the config object.
     * Keys are the config properties and the values are the default values for the config.
     * @param initialSetters A list of initial setters for this ConfigBuilder.
     * @returns {ConfigBuilderFactory<T>}
     */
    static compose<T>(defaultConfigValues?: T, initialSetters?: string[]): ConfigBuilderFactory<T>;
    static composeWith<T, Z extends typeof ConfigBuilder>(builderType: Z, defaultConfigValues?: T, initialSetters?: string[]): ConfigBuilderFactory<T>;
    toJSON(): T;
}
