"use strict";
/**
 * Simple object extend
 * @param m1
 * @param m2
 * @returns {{}}
 */
function extend(m1, m2) {
    var m = {};
    for (var attr in m1) {
        if (m1.hasOwnProperty(attr)) {
            m[attr] = m1[attr];
        }
    }
    for (var attr in m2) {
        if (m2.hasOwnProperty(attr)) {
            m[attr] = m2[attr];
        }
    }
    return m;
}
exports.extend = extend;
/**
 * Simple, not optimized, array union of unique values.
 * @param arr1
 * @param arr2
 * @returns {T[]|any[]|any[][]|any[]}
 */
function arrayUnion(arr1, arr2) {
    return arr1
        .concat(arr2.filter(function (v) { return arr1.indexOf(v) === -1; }));
}
exports.arrayUnion = arrayUnion;
//# sourceMappingURL=data:application/json;base64,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