"use strict";
var __extends = (this && this.__extends) || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
    function __() { this.constructor = d; }
    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
};
var ModalAwarePreset_1 = require('./ModalAwarePreset');
var MessageModal_1 = require('../../modals/MessageModal');
var Utils_1 = require('../../framework/Utils');
var DEFAULT_CONFIG_VALUES = {
    component: MessageModal_1.MessageModal,
    headerClass: 'modal-header',
    bodyClass: 'modal-body',
    footerClass: 'modal-footer'
};
var DEFAULT_INITIAL_SETTERS = [
    'headerClass',
    'title',
    'titleHtml',
    'body',
    'bodyClass',
    'footerClass'
];
/**
 * A Preset representing the configuration needed to open MessageModal.
 * This is an abstract implementation with no concrete behaviour.
 * Use derived implementation.
 */
var MessageModalPreset = (function (_super) {
    __extends(MessageModalPreset, _super);
    function MessageModalPreset(defaultValues, initialSetters) {
        if (defaultValues === void 0) { defaultValues = undefined; }
        if (initialSetters === void 0) { initialSetters = undefined; }
        _super.call(this, Utils_1.extend(DEFAULT_CONFIG_VALUES, defaultValues || {}), Utils_1.arrayUnion(DEFAULT_INITIAL_SETTERS, initialSetters || []));
    }
    return MessageModalPreset;
}(ModalAwarePreset_1.ModalAwarePreset));
exports.MessageModalPreset = MessageModalPreset;
//# sourceMappingURL=data:application/json;base64,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