"use strict";
var __extends = (this && this.__extends) || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
    function __() { this.constructor = d; }
    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
};
var Modal_1 = require('../../providers/Modal');
var ModalConfig_1 = require('../../models/ModalConfig');
var FluentAssign_1 = require('./../../framework/FluentAssign');
/**
 * A Preset that knows about the modal service, and so can open a modal window on demand.
 * Use the fluent API to configure the preset and then invoke the 'open' method to open a modal
 * based on the preset.
 * ModalAwarePreset occupy the following properties:
 * - ModalConfig (size, isBlocking, keyboard): You can set them, if not they will get the
 * default values defined in the Modal service.
 * - component, modal, bindings: Preset values needed to fire up the modal.
 * - open: A Method used to open the modal window.
 */
var ModalAwarePreset = (function (_super) {
    __extends(ModalAwarePreset, _super);
    function ModalAwarePreset(defaultValues, initialSetters) {
        if (defaultValues === void 0) { defaultValues = undefined; }
        if (initialSetters === void 0) { initialSetters = undefined; }
        _super.call(this, defaultValues, initialSetters);
        // this is not needed as we get them via defaults.
        // but it "protects" overwrites since we set writeOnce=true.
        FluentAssign_1.setAssignMethod(this, 'modal', true);
        FluentAssign_1.setAssignMethod(this, 'component', true);
        FluentAssign_1.setAssignMethod(this, 'bindings', true);
        FluentAssign_1.setAssignMethod(this, 'size');
        FluentAssign_1.setAssignMethod(this, 'isBlocking');
        FluentAssign_1.setAssignMethod(this, 'keyboard');
        FluentAssign_1.setAssignMethod(this, 'dialogClass');
    }
    /**
     * Open a modal window based on the configuration of this config instance.
     * @param inside If set opens the modal inside the supplied elements ref at the specified anchor
     * @returns Promise<ModalDialogInstance>
     */
    ModalAwarePreset.prototype.open = function (inside) {
        var config = this.toJSON();
        if (!(config.modal instanceof Modal_1.Modal)) {
            return Promise.reject(new Error('Configuration Error: modal service not set.'));
        }
        if (typeof config.bindings !== 'function') {
            return Promise.reject(new Error('Configuration Error: bindings not set.'));
        }
        if (inside) {
            // TODO: Validate inside?
            return config.modal.openInside(config.component, inside.elementRef, inside.anchorName, config.bindings(config), new ModalConfig_1.ModalConfig(config.size, config.isBlocking, config.keyboard));
        }
        else {
            return config.modal.open(config.component, config.bindings(config), new ModalConfig_1.ModalConfig(config.size, config.isBlocking, config.keyboard, config.dialogClass));
        }
    };
    return ModalAwarePreset;
}(FluentAssign_1.FluentAssign));
exports.ModalAwarePreset = ModalAwarePreset;
//# sourceMappingURL=data:application/json;base64,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