var __extends = (this && this.__extends) || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
    function __() { this.constructor = d; }
    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
};
(function (global, factory) {
    typeof exports === 'object' && typeof module !== 'undefined' ? factory(exports, require('@angular/core'), require('angular2-modal')) :
        typeof define === 'function' && define.amd ? define(['exports', '@angular/core', 'angular2-modal'], factory) :
            (factory((global.angular2Modal = global.angular2Modal || {}, global.angular2Modal.plugins = global.angular2Modal.plugins || {}, global.angular2Modal.plugins.jsNative = global.angular2Modal.plugins.jsNative || {}), global.ng.core, global.angular2 - modal));
}(this, (function (exports, _angular_core, angular2Modal) {
    'use strict';
    /**
     * angular2-modal - Angular2 Modal (dialog) window.
     * @version v2.0.0-beta.10
     * @link https://github.com/shlomiassaf/angular2-modal
     * @license MIT
     */
    var DEFAULT_SETTERS = [
        'promptDefault'
    ];
    var JSNativeModalContext = (function (_super) {
        __extends(JSNativeModalContext, _super);
        function JSNativeModalContext() {
            _super.apply(this, arguments);
        }
        JSNativeModalContext.prototype.normalize = function () {
            if (!this.message)
                this.message = '';
            if (this.dialogType === undefined)
                this.dialogType = angular2Modal.DROP_IN_TYPE.alert;
        };
        return JSNativeModalContext;
    }(angular2Modal.ModalOpenContext));
    var JSNativeModalContextBuilder = (function (_super) {
        __extends(JSNativeModalContextBuilder, _super);
        function JSNativeModalContextBuilder(defaultValues, initialSetters, baseType) {
            if (defaultValues === void 0) { defaultValues = undefined; }
            if (initialSetters === void 0) { initialSetters = undefined; }
            if (baseType === void 0) { baseType = undefined; }
            _super.call(this, defaultValues || {}, angular2Modal.arrayUnion(DEFAULT_SETTERS, initialSetters || []), baseType || JSNativeModalContext);
        }
        return JSNativeModalContextBuilder;
    }(angular2Modal.ModalOpenContextBuilder));
    /**
     * angular2-modal - Angular2 Modal (dialog) window.
     * @version v2.0.0-beta.10
     * @link https://github.com/shlomiassaf/angular2-modal
     * @license MIT
     */
    var __decorate$1 = (undefined && undefined.__decorate) || function (decorators, target, key, desc) {
        var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
        if (typeof Reflect === "object" && typeof Reflect.decorate === "function")
            r = Reflect.decorate(decorators, target, key, desc);
        else
            for (var i = decorators.length - 1; i >= 0; i--)
                if (d = decorators[i])
                    r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
        return (c > 3 && r && Object.defineProperty(target, key, r), r);
    };
    var __metadata$1 = (undefined && undefined.__metadata) || function (k, v) {
        if (typeof Reflect === "object" && typeof Reflect.metadata === "function")
            return Reflect.metadata(k, v);
    };
    exports.JSNativeModalRenderer = (function () {
        function JSNativeModalRenderer() {
        }
        JSNativeModalRenderer.prototype.render = function (dialog, vcRef) {
            var result;
            switch (dialog.context.dialogType) {
                case angular2Modal.DROP_IN_TYPE.alert:
                    window.alert(dialog.context.message);
                    result = true;
                    break;
                case angular2Modal.DROP_IN_TYPE.prompt:
                    result = window.prompt(dialog.context.message, dialog.context.promptDefault);
                    break;
                case angular2Modal.DROP_IN_TYPE.confirm:
                    result = window.confirm(dialog.context.message);
                    break;
            }
            dialog.destroy = function () {
            };
            if (result === false) {
                dialog.dismiss();
            }
            else {
                dialog.close(result);
            }
            // we need to return ComponentRef<ModalOverlay> but a native dialog does'nt have that
            // so we resolve an empty promise, the user of this renderer should expect that.
            return {};
        };
        return JSNativeModalRenderer;
    }());
    exports.JSNativeModalRenderer = __decorate$1([
        _angular_core.Injectable(),
        __metadata$1('design:paramtypes', [])
    ], exports.JSNativeModalRenderer);
    /**
     * angular2-modal - Angular2 Modal (dialog) window.
     * @version v2.0.0-beta.10
     * @link https://github.com/shlomiassaf/angular2-modal
     * @license MIT
     */
    var JSNativePresetBuilder = (function (_super) {
        __extends(JSNativePresetBuilder, _super);
        function JSNativePresetBuilder(modal, dialogType) {
            _super.call(this, { modal: modal, dialogType: dialogType });
        }
        /**
         * Hook to alter config and return bindings.
         * @param config
         */
        JSNativePresetBuilder.prototype.$$beforeOpen = function (config) {
            return [];
        };
        /**
         * Open a modal window based on the configuration of this config instance.
         * @param viewContainer If set opens the modal inside the supplied viewContainer
         * @returns Promise<DialogRef>
         */
        JSNativePresetBuilder.prototype.open = function (viewContainer) {
            var context = this.toJSON();
            if (!(context.modal instanceof exports.Modal)) {
                return Promise.reject(new Error('Configuration Error: modal service not set.'));
            }
            var overlayConfig = {
                context: context,
                renderer: new exports.JSNativeModalRenderer(),
                viewContainer: viewContainer,
                bindings: typeof this.$$beforeOpen === 'function' && this.$$beforeOpen(context)
            };
            return context.modal.open(context.component, overlayConfig);
        };
        return JSNativePresetBuilder;
    }(JSNativeModalContextBuilder));
    /**
     * angular2-modal - Angular2 Modal (dialog) window.
     * @version v2.0.0-beta.10
     * @link https://github.com/shlomiassaf/angular2-modal
     * @license MIT
     */
    var __decorate = (undefined && undefined.__decorate) || function (decorators, target, key, desc) {
        var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
        if (typeof Reflect === "object" && typeof Reflect.decorate === "function")
            r = Reflect.decorate(decorators, target, key, desc);
        else
            for (var i = decorators.length - 1; i >= 0; i--)
                if (d = decorators[i])
                    r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
        return (c > 3 && r && Object.defineProperty(target, key, r), r);
    };
    var __metadata = (undefined && undefined.__metadata) || function (k, v) {
        if (typeof Reflect === "object" && typeof Reflect.metadata === "function")
            return Reflect.metadata(k, v);
    };
    exports.Modal = (function (_super) {
        __extends(Modal, _super);
        function Modal(overlay) {
            _super.call(this, overlay);
        }
        Modal.prototype.alert = function () {
            return new JSNativePresetBuilder(this, angular2Modal.DROP_IN_TYPE.alert);
        };
        Modal.prototype.prompt = function () {
            return new JSNativePresetBuilder(this, angular2Modal.DROP_IN_TYPE.prompt);
        };
        Modal.prototype.confirm = function () {
            return new JSNativePresetBuilder(this, angular2Modal.DROP_IN_TYPE.confirm);
        };
        Modal.prototype.create = function (dialogRef, type, bindings) {
            return dialogRef;
        };
        return Modal;
    }(angular2Modal.Modal));
    exports.Modal = __decorate([
        _angular_core.Injectable(),
        __metadata('design:paramtypes', [angular2Modal.Overlay])
    ], exports.Modal);
    /**
     * angular2-modal - Angular2 Modal (dialog) window.
     * @version v2.0.0-beta.10
     * @link https://github.com/shlomiassaf/angular2-modal
     * @license MIT
     */
    var __decorate$2 = (undefined && undefined.__decorate) || function (decorators, target, key, desc) {
        var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
        if (typeof Reflect === "object" && typeof Reflect.decorate === "function")
            r = Reflect.decorate(decorators, target, key, desc);
        else
            for (var i = decorators.length - 1; i >= 0; i--)
                if (d = decorators[i])
                    r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
        return (c > 3 && r && Object.defineProperty(target, key, r), r);
    };
    var __metadata$2 = (undefined && undefined.__metadata) || function (k, v) {
        if (typeof Reflect === "object" && typeof Reflect.metadata === "function")
            return Reflect.metadata(k, v);
    };
    function getProviders() {
        return [
            { provide: angular2Modal.Modal, useClass: exports.Modal },
            { provide: exports.Modal, useClass: exports.Modal }
        ];
    }
    exports.JSNativeModalModule = (function () {
        function JSNativeModalModule() {
        }
        JSNativeModalModule.getProviders = function () {
            return getProviders();
        };
        return JSNativeModalModule;
    }());
    exports.JSNativeModalModule = __decorate$2([
        _angular_core.NgModule({
            providers: getProviders()
        }),
        __metadata$2('design:paramtypes', [])
    ], exports.JSNativeModalModule);
    exports.JSNativeModalContext = JSNativeModalContext;
    exports.JSNativeModalContextBuilder = JSNativeModalContextBuilder;
    exports.JSNativePresetBuilder = JSNativePresetBuilder;
    Object.defineProperty(exports, '__esModule', { value: true });
})));
