/**
 * angular2-modal - Angular2 Modal (dialog) window.
 * @version v2.0.0-beta.10
 * @link https://github.com/shlomiassaf/angular2-modal
 * @license MIT
 */
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return (c > 3 && r && Object.defineProperty(target, key, r), r);
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
import { Directive, Input, ElementRef, ViewContainerRef } from '@angular/core';
import { DialogRef } from '../models/dialog-ref';
import { vcRefStore } from '../models/vc-ref-store';
/**
 * A directive use to signal the overlay that the host of this directive
 * is a dialog boundary, i.e: over click outside of the element should close the modal
 * (if non blocking)
 */
export let OverlayDialogBoundary = class OverlayDialogBoundary {
    constructor(el, dialogRef) {
        if (dialogRef && el.nativeElement) {
            dialogRef.overlayRef.instance.setClickBoundary(el.nativeElement);
        }
    }
};
OverlayDialogBoundary = __decorate([
    Directive({
        selector: '[overlayDialogBoundary]'
    }), 
    __metadata('design:paramtypes', [ElementRef, DialogRef])
], OverlayDialogBoundary);
export let OverlayTarget = class OverlayTarget {
    constructor(vcRef) {
        this.vcRef = vcRef;
    }
    set targetKey(value) {
        this._targetKey = value;
        if (value) {
            vcRefStore.setVCRef(value, this.vcRef);
        }
    }
    ngOnDestroy() {
        if (this._targetKey) {
            vcRefStore.delVCRef(this._targetKey, this.vcRef);
        }
    }
};
__decorate([
    Input('overlayTarget'), 
    __metadata('design:type', String), 
    __metadata('design:paramtypes', [String])
], OverlayTarget.prototype, "targetKey", null);
OverlayTarget = __decorate([
    Directive({
        selector: '[overlayTarget]'
    }), 
    __metadata('design:paramtypes', [ViewContainerRef])
], OverlayTarget);

//# sourceMappingURL=overlay.directives.js.map
