/**
 * angular2-modal - Angular2 Modal (dialog) window.
 * @version v2.0.0-beta.10
 * @link https://github.com/shlomiassaf/angular2-modal
 * @license MIT
 */
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return (c > 3 && r && Object.defineProperty(target, key, r), r);
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
import 'rxjs/add/operator/first';
import { Injectable } from '@angular/core';
import { Overlay, Modal as Modal_, CSSBackdrop, CSSDialogContainer, PromiseCompleter } from "angular2-modal";
import { BSModalContainer } from './modal-container.component';
import { OneButtonPresetBuilder } from './../bootstrap/presets/one-button-preset';
import { TwoButtonPresetBuilder } from './../bootstrap/presets/two-button-preset';
export let Modal = class Modal extends Modal_ {
    constructor(overlay) {
        super(overlay);
    }
    alert() {
        return new OneButtonPresetBuilder(this, { isBlocking: false });
    }
    prompt() {
        return new OneButtonPresetBuilder(this, { isBlocking: true, keyboard: null });
    }
    confirm() {
        return new TwoButtonPresetBuilder(this, { isBlocking: true, keyboard: null });
    }
    create(dialogRef, type, bindings) {
        let refs = this.createModal(dialogRef, CSSBackdrop, CSSDialogContainer);
        refs.containerRef
            .instance.addComponent(BSModalContainer, bindings)
            .instance.addComponent(type, bindings);
        let overlay = dialogRef.overlayRef.instance;
        let backdrop = refs.backdropRef.instance;
        let container = refs.containerRef.instance;
        dialogRef.inElement ? overlay.insideElement() : overlay.fullscreen();
        // add body class if this is the only dialog in the stack
        if (!document.body.classList.contains('modal-open')) {
            document.body.classList.add('modal-open');
        }
        backdrop.addClass('modal-backdrop fade', true);
        container.setStyle('position', 'absolute');
        container.setStyle('display', 'block');
        container.addClass('modal fade', true);
        backdrop.addClass('in');
        container.addClass('in');
        if (refs.containerRef.location.nativeElement) {
            refs.containerRef.location.nativeElement.focus();
        }
        overlay.beforeDestroy(() => {
            const completer = new PromiseCompleter();
            backdrop.removeClass('in');
            container.removeClass('in');
            backdrop.animationEnd$.first().subscribe(type => {
                this.overlay.groupStackLength(dialogRef) === 1 && document.body.classList.remove('modal-open');
                completer.resolve();
            });
            return completer.promise;
        });
        return dialogRef;
    }
};
Modal = __decorate([
    Injectable(), 
    __metadata('design:paramtypes', [Overlay])
], Modal);

//# sourceMappingURL=modal.js.map
