/**
 * angular2-modal - Angular2 Modal (dialog) window.
 * @version v2.0.0-beta.10
 * @link https://github.com/shlomiassaf/angular2-modal
 * @license MIT
 */
import { Modal } from '../modal';
import { JSNativeModalContextBuilder } from '../modal-context';
import { JSNativeModalRenderer } from '../js-native-modal-renderer';
export class JSNativePresetBuilder extends JSNativeModalContextBuilder {
    constructor(modal, dialogType) {
        super({ modal, dialogType });
    }
    /**
     * Hook to alter config and return bindings.
     * @param config
     */
    $$beforeOpen(config) {
        return [];
    }
    /**
     * Open a modal window based on the configuration of this config instance.
     * @param viewContainer If set opens the modal inside the supplied viewContainer
     * @returns Promise<DialogRef>
     */
    open(viewContainer) {
        let context = this.toJSON();
        if (!(context.modal instanceof Modal)) {
            return Promise.reject(new Error('Configuration Error: modal service not set.'));
        }
        let overlayConfig = {
            context: context,
            renderer: new JSNativeModalRenderer(),
            viewContainer: viewContainer,
            bindings: typeof this.$$beforeOpen === 'function' && this.$$beforeOpen(context)
        };
        return context.modal.open(context.component, overlayConfig);
    }
}

//# sourceMappingURL=js-native-preset.js.map
