/**
 * angular2-modal - Angular2 Modal (dialog) window.
 * @version v2.0.0-beta.10
 * @link https://github.com/shlomiassaf/angular2-modal
 * @license MIT
 */
import { ReflectiveInjector } from '@angular/core';
import { DialogRef } from '../models/dialog-ref';
export class UnsupportedDropInError extends Error {
    constructor(dropInName) {
        super();
        this.message = `Unsupported Drop-In ${dropInName}`;
    }
}
export class Modal {
    constructor(overlay) {
        this.overlay = overlay;
    }
    alert() {
        throw new UnsupportedDropInError('alert');
    }
    prompt() {
        throw new UnsupportedDropInError('prompt');
    }
    confirm() {
        throw new UnsupportedDropInError('confirm');
    }
    /**
     * Opens a modal window inside an existing component.
     * @param componentType The angular Component to render as the modal content.
     * @param config Additional settings.
     * @returns {Promise<DialogRef>}
     */
    open(componentType, config) {
        config = config || {};
        try {
            let dialogs = this.overlay.open(config, this.constructor);
            if (dialogs.length > 1) {
                console.warn(`Attempt to open more then 1 overlay detected.
        Multiple modal copies are not supported at the moment, 
        only the first viewContainer will display.`);
            }
            // TODO:  Currently supporting 1 view container, hence working on dialogs[0].
            //        upgrade to multiple containers.
            return Promise.resolve(this.create(dialogs[0], componentType, config.bindings));
        }
        catch (e) {
            return Promise.reject(e);
        }
    }
    /**
     * A helper function for derived classes to create backdrop & container
     * @param dialogRef
     * @param backdrop
     * @param container
     * @returns { backdropRef: ComponentRef<B>, containerRef: ComponentRef<C> }
     */
    createModal(dialogRef, backdrop, container) {
        const b = ReflectiveInjector.resolve([{ provide: DialogRef, useValue: dialogRef }]);
        return {
            backdropRef: dialogRef.overlayRef.instance.addComponent(backdrop, b),
            containerRef: dialogRef.overlayRef.instance.addComponent(container, b)
        };
    }
}

//# sourceMappingURL=modal.js.map
