/**
 * angular2-modal - Angular2 Modal (dialog) window.
 * @version v2.0.0-beta.12
 * @link https://github.com/shlomiassaf/angular2-modal
 * @license MIT
 */
const BASKET_GROUP = {};
/**
 * A dumb stack implementation over an array.
 */
export class DialogRefStack {
    constructor() {
        this._stack = [];
        this._stackMap = new Map();
    }
    get length() {
        return this._stack.length;
    }
    push(dialogRef, group) {
        if (this._stack.indexOf(dialogRef) === -1) {
            this._stack.push(dialogRef);
            this._stackMap.set(dialogRef, group || BASKET_GROUP);
        }
    }
    /**
     * Push a DialogRef into the stack and manage it so when it's done
     * it will automatically kick itself out of the stack.
     * @param dialogRef
     */
    pushManaged(dialogRef, group) {
        this.push(dialogRef, group);
        dialogRef.onDestroy.subscribe(() => this.remove(dialogRef));
    }
    pop() {
        const dialogRef = this._stack.pop();
        this._stackMap.delete(dialogRef);
        return dialogRef;
    }
    /**
     * Remove a DialogRef from the stack.
     * @param dialogRef
     */
    remove(dialogRef) {
        let idx = this.indexOf(dialogRef);
        if (idx > -1) {
            this._stack.splice(idx, 1);
            this._stackMap.delete(dialogRef);
        }
    }
    index(index) {
        return this._stack[index];
    }
    indexOf(dialogRef) {
        return this._stack.indexOf(dialogRef);
    }
    groupOf(dialogRef) {
        return this._stackMap.get(dialogRef);
    }
    groupBy(group) {
        let arr = [];
        if (group) {
            this._stackMap.forEach((value, key) => {
                if (value === group) {
                    arr.push(key);
                }
            });
        }
        return arr;
    }
    groupLength(group) {
        let count = 0;
        if (group) {
            this._stackMap.forEach((value, key) => {
                if (value === group) {
                    count++;
                }
            });
        }
        return count;
    }
}

//# sourceMappingURL=dialog-ref-stack.js.map
