/**
 * angular2-modal - Angular2 Modal (dialog) window.
 * @version v2.0.0-beta.12
 * @link https://github.com/shlomiassaf/angular2-modal
 * @license MIT
 */
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return (c > 3 && r && Object.defineProperty(target, key, r), r);
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
import { Component, ElementRef, ViewChild, ViewContainerRef, ViewEncapsulation, Renderer, TemplateRef } from '@angular/core';
import { PromiseCompleter, supportsKey } from '../framework/utils';
import { DialogRef } from '../models/dialog-ref';
import { BaseDynamicComponent } from '../components/index';
/**
 * Represents the modal overlay.
 */
export let ModalOverlay = class ModalOverlay extends BaseDynamicComponent {
    constructor(dialogRef, vcr, el, renderer) {
        super(el, renderer);
        this.dialogRef = dialogRef;
        this.vcr = vcr;
        this.activateAnimationListener();
    }
    /**
     * @internal
     */
    getProjectables(content, bindings) {
        let nodes;
        if (typeof content === 'string') {
            nodes = [[this.renderer.createText(null, `${content}`)]];
        }
        else if (content instanceof TemplateRef) {
            nodes = [
                this.dialogRef.overlay.defaultViewContainer
                    .createEmbeddedView(content, { dialogRef: this.dialogRef }).rootNodes
            ];
        }
        else {
            nodes = [this.embedComponent({ component: content, bindings: bindings }).rootNodes];
        }
        return nodes;
    }
    embedComponent(config) {
        return this.vcr.createEmbeddedView(this.template, {
            $implicit: config
        });
    }
    addComponent(type, bindings=[], projectableNodes=[]) {
        return super._addComponent(type, this.innerVcr, bindings, projectableNodes);
    }
    fullscreen() {
        const style = {
            position: 'fixed',
            top: 0,
            left: 0,
            bottom: 0,
            right: 0,
            'z-index': 1500
        };
        Object.keys(style).forEach(k => this.setStyle(k, style[k]));
    }
    insideElement() {
        const style = {
            position: 'absolute',
            overflow: 'hidden',
            width: '100%',
            height: '100%',
            top: 0,
            left: 0,
            bottom: 0,
            right: 0
        };
        Object.keys(style).forEach(k => this.setStyle(k, style[k]));
    }
    /**
     * Define an element that click inside it will not trigger modal close.
     * Since events bubble, clicking on a dialog will bubble up to the overlay, a plugin
     * must define an element that represent the dialog, the overlay will make sure no to close when
     * it was clicked.
     * @param element
     */
    setClickBoundary(element) {
        let target;
        const elListener = event => target = event.target;
        const docListener = event => {
            if (this.dialogRef.context.isBlocking || !this.dialogRef.overlay.isTopMost(this.dialogRef)) {
                return;
            }
            let current = event.target;
            // on click, this will hit.
            if (current === target)
                return;
            // on mouse down -> drag -> release the current might not be 'target', it might be
            // a sibling or a child (i.e: not part of the tree-up direction). It might also be a release
            // outside the dialog... so we compare to the boundary element
            do {
                if (current === element) {
                    return;
                }
            } while (current.parentNode && (current = current.parentNode));
            this.dialogRef.dismiss();
        };
        this.dialogRef.onDestroy.subscribe(() => {
            element.removeEventListener('click', elListener, false);
            element.removeEventListener('touchstart', elListener, false);
            document.removeEventListener('click', docListener, false);
            document.removeEventListener('touchend', docListener, false);
        });
        setTimeout(() => {
            element.addEventListener('mousedown', elListener, false);
            element.addEventListener('touchstart', docListener, false);
            document.addEventListener('click', docListener, false);
            document.addEventListener('touchend', docListener, false);
        });
    }
    /**
     * Temp workaround for animation where destruction of the top level component does not
     * trigger child animations. Solution should be found either in animation module or in design
     * of the modal component tree.
     * @returns {Promise<void>}
     */
    canDestroy() {
        const completer = new PromiseCompleter();
        if (!Array.isArray(this.beforeDestroyHandlers)) {
            completer.resolve();
        }
        else {
            // run destroy notification but protect against halt.
            let id = setTimeout(() => {
                id = null;
                completer.reject();
            }, 1000);
            const resolve = () => {
                if (id === null)
                    return;
                clearTimeout(id);
                completer.resolve();
            };
            Promise.all(this.beforeDestroyHandlers.map(fn => fn()))
                .then(resolve)
                .catch(resolve);
        }
        return completer.promise;
    }
    /**
     * A handler running before destruction of the overlay
     * use to delay destruction due to animation.
     * This is part of the workaround for animation, see canDestroy.
     *
     * NOTE: There is no guarantee that the listeners will fire, use dialog.onDestory for that.
     * @param fn
     */
    beforeDestroy(fn) {
        if (!this.beforeDestroyHandlers) {
            this.beforeDestroyHandlers = [];
        }
        this.beforeDestroyHandlers.push(fn);
    }
    documentKeypress(event) {
        // check that this modal is the last in the stack.
        if (!this.dialogRef.overlay.isTopMost(this.dialogRef))
            return;
        if (supportsKey(event.keyCode, this.dialogRef.context.keyboard)) {
            this.dialogRef.dismiss();
        }
    }
    ngOnDestroy() {
        super.ngOnDestroy();
        if (this.dialogRef.destroyed !== true) {
            // if we're here the overlay is destroyed by an external event that is not user invoked.
            // i.e: The user did no call dismiss or close and dialogRef.destroy() did not invoke.
            // this will happen when routing or killing an element containing a blocked overlay (ngIf)
            // we bail out, i.e gracefully shutting down.
            this.dialogRef.bailOut();
        }
    }
};
__decorate([
    ViewChild('innerView', { read: ViewContainerRef }), 
    __metadata('design:type', ViewContainerRef)
], ModalOverlay.prototype, "innerVcr", void 0);
__decorate([
    ViewChild('template'), 
    __metadata('design:type', TemplateRef)
], ModalOverlay.prototype, "template", void 0);
ModalOverlay = __decorate([
    Component({
        selector: 'modal-overlay',
        host: {
            '(body:keydown)': 'documentKeypress($event)'
        },
        encapsulation: ViewEncapsulation.None,
        template: `<template #innerView></template>
<template #template let-ctx>
    <template [swapCmp]="ctx.component" [swapCmpBindings]="ctx.bindings" [swapCmpProjectables]="ctx.projectableNodes"></template>
</template>
`
    }), 
    __metadata('design:paramtypes', [DialogRef, ViewContainerRef, ElementRef, Renderer])
], ModalOverlay);

//# sourceMappingURL=overlay.component.js.map
