/**
 * angular2-modal - Angular2 Modal (dialog) window.
 * @version v2.0.0-beta.12
 * @link https://github.com/shlomiassaf/angular2-modal
 * @license MIT
 */
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return (c > 3 && r && Object.defineProperty(target, key, r), r);
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
import { Component, ViewEncapsulation } from '@angular/core';
import { DialogRef } from "angular2-modal";
export let BSMessageModalTitle = class BSMessageModalTitle {
    constructor(dialog) {
        this.dialog = dialog;
        this.context = dialog.context;
    }
    get titleHtml() {
        return this.context.titleHtml ? 1 : 0;
    }
};
BSMessageModalTitle = __decorate([
    Component({
        selector: 'modal-title',
        encapsulation: ViewEncapsulation.None,
        template: `<div [ngClass]="context.headerClass" [ngSwitch]="titleHtml">
      <button *ngIf="context.showClose" type="button" class="close" 
              aria-label="Close" (click)="dialog.dismiss()">
          <span aria-hidden="true">×</span>
      </button>
      <div *ngSwitchCase="1" [innerHtml]="context.titleHtml"></div>
      <h3 *ngSwitchDefault class="modal-title">{{context.title}}</h3>
 </div>`
    }), 
    __metadata('design:paramtypes', [DialogRef])
], BSMessageModalTitle);
export let BSMessageModalBody = class BSMessageModalBody {
    constructor(dialog) {
        this.dialog = dialog;
        this.context = dialog.context;
    }
};
BSMessageModalBody = __decorate([
    Component({
        selector: 'modal-body',
        encapsulation: ViewEncapsulation.None,
        styles: [`.form-group {
    margin-top: 10px;
  }`],
        template: `<div [ngClass]="context.bodyClass"> 
    <div [innerHtml]="context.message"></div>
      <div *ngIf="context.showInput" class="form-group">
        <input autofocus #input
            name="bootstrap" 
            type="text" 
            class="form-control"
            [value]="context.defaultValue"
            (change)="context.defaultValue = input.value"  
            placeholder="{{context.placeholder}}">
      </div>
    </div>
`
    }), 
    __metadata('design:paramtypes', [DialogRef])
], BSMessageModalBody);
/**
 * Represents the modal footer for storing buttons.
 */
export let BSModalFooter = class BSModalFooter {
    constructor(dialog) {
        this.dialog = dialog;
    }
    onClick(btn, $event) {
        $event.stopPropagation();
        btn.onClick(this, $event);
    }
};
BSModalFooter = __decorate([
    Component({
        selector: 'modal-footer',
        encapsulation: ViewEncapsulation.None,
        template: `<div [ngClass]="dialog.context.footerClass">
    <button *ngFor="let btn of dialog.context.buttons;"
            [ngClass]="btn.cssClass"
            (click)="onClick(btn, $event)">{{btn.caption}}</button>
</div>`
    }), 
    __metadata('design:paramtypes', [DialogRef])
], BSModalFooter);
/**
 * A Component representing a generic bootstrap modal content element.
 *
 * By configuring a MessageModalContext instance you can:
 *
 *  Header:
 *      - Set header container class (default: modal-header)
 *      - Set title text (enclosed in H3 element)
 *      - Set title html (overrides text)
 *
 *  Body:
 *      - Set body container class.  (default: modal-body)
 *      - Set body container HTML.
 *
 *  Footer:
 *      - Set footer class.  (default: modal-footer)
 *      - Set button configuration (from 0 to n)
 */
export let BSMessageModal = class BSMessageModal {
    constructor(dialog) {
        this.dialog = dialog;
    }
};
BSMessageModal = __decorate([
    Component({
        selector: 'modal-content',
        encapsulation: ViewEncapsulation.None,
        template: `<modal-title></modal-title><modal-body></modal-body><modal-footer></modal-footer>`
    }), 
    __metadata('design:paramtypes', [DialogRef])
], BSMessageModal);

//# sourceMappingURL=message-modal.component.js.map
