/**
 * angular2-modal - Angular2 Modal (dialog) window.
 * @version v2.0.0-beta.12
 * @link https://github.com/shlomiassaf/angular2-modal
 * @license MIT
 */
import { extend, arrayUnion } from "angular2-modal";
import { MessageModalPresetBuilder } from './message-modal-preset';
/** Common two button preset */
export class AbstractTwoButtonPresetBuilder extends MessageModalPresetBuilder {
    constructor(modal, defaultValues=undefined, initialSetters=[]) {
        super(extend({
            modal: modal,
            okBtn: 'OK',
            okBtnClass: 'btn btn-primary',
            cancelBtn: 'Cancel',
            cancelBtnClass: 'btn btn-default'
        }, defaultValues || {}), arrayUnion([
            'okBtn',
            'okBtnClass',
            'cancelBtn',
            'cancelBtnClass',
        ], initialSetters));
    }
    $$beforeOpen(config) {
        this.addButton(config.cancelBtnClass, config.cancelBtn, (cmp, $event) => cmp.dialog.dismiss());
        return super.$$beforeOpen(config);
    }
}
/**
 * A Preset for a classic 2 button modal window.
 */
export class TwoButtonPresetBuilder extends AbstractTwoButtonPresetBuilder {
    constructor(modal, defaultValues=undefined) {
        super(modal, defaultValues);
    }
    $$beforeOpen(config) {
        this.addButton(config.okBtnClass, config.okBtn, (cmp, $event) => cmp.dialog.close(true));
        return super.$$beforeOpen(config);
    }
}
export class PromptPresetBuilder extends AbstractTwoButtonPresetBuilder {
    constructor(modal, defaultValues=undefined) {
        super(modal, extend({ showInput: true, defaultValue: '' }, defaultValues || {}), ['placeholder', 'defaultValue']);
    }
    $$beforeOpen(config) {
        this.addButton(config.okBtnClass, config.okBtn, (cmp, $event) => cmp.dialog.close(cmp.dialog.context.defaultValue));
        return super.$$beforeOpen(config);
    }
}

//# sourceMappingURL=two-button-preset.js.map
