/**
 * angular2-modal - Angular2 Modal (dialog) window.
 * @version v2.0.0-beta.12
 * @link https://github.com/shlomiassaf/angular2-modal
 * @license MIT
 */
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return (c > 3 && r && Object.defineProperty(target, key, r), r);
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
import 'rxjs/add/operator/first';
import { Injectable } from '@angular/core';
import { Overlay, DROP_IN_TYPE, Modal as Modal_, CSSBackdrop, CSSDialogContainer, PromiseCompleter } from "angular2-modal";
import { DropInPresetBuilder } from './presets/dropin-preset';
export let Modal = class Modal extends Modal_ {
    constructor(overlay) {
        super(overlay);
    }
    alert() {
        return new DropInPresetBuilder(this, DROP_IN_TYPE.alert, { isBlocking: false });
    }
    prompt() {
        return new DropInPresetBuilder(this, DROP_IN_TYPE.prompt, {
            isBlocking: true,
            keyboard: null
        });
    }
    confirm() {
        return new DropInPresetBuilder(this, DROP_IN_TYPE.confirm, {
            isBlocking: true,
            keyboard: null
        });
    }
    create(dialogRef, content, bindings) {
        const backdropRef = this.createBackdrop(dialogRef, CSSBackdrop);
        const containerRef = this.createContainer(dialogRef, CSSDialogContainer, content, bindings);
        let overlay = dialogRef.overlayRef.instance;
        let backdrop = backdropRef.instance;
        let container = containerRef.instance;
        dialogRef.inElement ? overlay.insideElement() : overlay.fullscreen();
        // add body class if this is the only dialog in the stack
        if (!document.body.classList.contains('vex-open')) {
            document.body.classList.add('vex-open');
        }
        overlay.addClass(`vex vex-theme-${dialogRef.context.className}`);
        backdrop.addClass('vex-overlay');
        container.addClass(dialogRef.context.contentClassName);
        container.setStyle('display', 'block');
        if (dialogRef.inElement) {
            overlay.setStyle('padding', '0');
            container.setStyle('margin-top', '20px');
        }
        if (containerRef.location.nativeElement) {
            containerRef.location.nativeElement.focus();
        }
        if (dialogRef.context.className === 'bottom-right-corner') {
            overlay.setStyle('overflow-y', 'hidden');
            container.setStyle('position', 'absolute');
        }
        overlay.beforeDestroy(() => {
            overlay.addClass('vex-closing');
            const completer = new PromiseCompleter();
            let animationEnd$ = container.myAnimationEnd$();
            if (dialogRef.context.className !== 'bottom-right-corner') {
                animationEnd$ = animationEnd$.combineLatest(backdrop.myAnimationEnd$(), (s1, s2) => [s1, s2]);
            }
            animationEnd$.subscribe(sources => {
                this.overlay.groupStackLength(dialogRef) === 1 && document.body.classList.remove('vex-open');
                completer.resolve();
            });
            return completer.promise;
        });
        overlay.setClickBoundary(containerRef.location.nativeElement);
        return dialogRef;
    }
};
Modal = __decorate([
    Injectable(), 
    __metadata('design:paramtypes', [Overlay])
], Modal);

//# sourceMappingURL=modal.js.map
