var __extends = (this && this.__extends) || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
    function __() { this.constructor = d; }
    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
};
(function (global, factory) {
    typeof exports === 'object' && typeof module !== 'undefined' ? factory(exports, require('@angular/core'), require('rxjs/Subject'), require('@angular/platform-browser')) :
        typeof define === 'function' && define.amd ? define(['exports', '@angular/core', 'rxjs/Subject', '@angular/platform-browser'], factory) :
            (factory((global.angular2Modal = global.angular2Modal || {}), global.ng.core, global.Rx, global.ng.platformBrowser));
}(this, (function (exports, _angular_core, rxjs_Subject, _angular_platformBrowser) {
    'use strict';
    /**
     * angular2-modal - Angular2 Modal (dialog) window.
     * @version v2.0.0-beta.2
     * @link https://github.com/shlomiassaf/angular2-modal
     * @license MIT
     */
    var PRIVATE_PREFIX = '$$';
    var RESERVED_REGEX = /^(\$\$).*/;
    function validateMethodName(name) {
        if (!name) {
            throw new Error("Illegal method name. Empty method name is not allowed");
        }
        else if (name in this) {
            throw new Error("A member name '" + name + "' already defined.");
        }
    }
    /**
     * Returns a list of assigned property names (non private)
     * @param subject
     * @returns {string[]}
     */
    function getAssignedPropertyNames(subject) {
        return Object.getOwnPropertyNames(subject)
            .filter(function (name) { return RESERVED_REGEX.test(name); })
            .map(function (name) { return name.substr(2); });
    }
    function privateKey(name) {
        return PRIVATE_PREFIX + name;
    }
    function objectDefinePropertyValue(obj, propertyName, value) {
        Object.defineProperty(obj, propertyName, {
            configurable: false,
            enumerable: false,
            writable: false,
            value: value
        });
    }
    /**
     * Given a FluentAssign instance, apply all of the supplied default values so calling
     * instance.toJSON will return those values (does not create a setter function)
     * @param instance
     * @param defaultValues
     */
    function applyDefaultValues(instance, defaultValues) {
        Object.getOwnPropertyNames(defaultValues)
            .forEach(function (name) { return instance[privateKey(name)] = defaultValues[name]; });
    }
    /**
     * Create a function for setting a value for a property on a given object.
     * @param obj The object to apply the key & setter on.
     * @param propertyName The name of the property on the object
     * @param writeOnce If true will allow writing once (default: false)
     *
     * Example:
     * let obj = new FluentAssign<any>;
     * setAssignMethod(obj, 'myProp');
     * obj.myProp('someValue');
     * const result = obj.toJSON();
     * console.log(result); //{ myProp: 'someValue' }
     *
     *
     * let obj = new FluentAssign<any>;
     * setAssignMethod(obj, 'myProp', true); // applying writeOnce
     * obj.myProp('someValue');
     * obj.myProp('someValue'); // ERROR: Overriding config property 'myProp' is not allowed.
     */
    function setAssignMethod(obj, propertyName, writeOnce) {
        var _this = this;
        if (writeOnce === void 0) { writeOnce = false; }
        validateMethodName.call(obj, propertyName);
        var key = privateKey(propertyName);
        objectDefinePropertyValue(obj, propertyName, function (value) {
            if (writeOnce && _this.hasOwnProperty(key)) {
                throw new Error("Overriding config property '" + propertyName + "' is not allowed.");
            }
            obj[key] = value;
            return obj;
        });
    }
    /**
     * Create a function for setting a value that is an alias to an other setter function.
     * @param obj The object to apply the key & setter on.
     * @param propertyName The name of the property on the object
     * @param srcPropertyName The name of the property on the object this alias points to
     * @param hard If true, will set a readonly property on the object that returns
     *        the value of the source property. Default: false
     *
     * Example:
     * let obj = new FluentAssign<any> ;
     * setAssignMethod(obj, 'myProp');
     * setAssignAlias(obj, 'myPropAlias', 'myProp');
     * obj.myPropAlias('someValue');
     * const result = obj.toJSON();
     * console.log(result); //{ myProp: 'someValue' }
     * result.myPropAlias // undefined
     *
     *
     * let obj = new FluentAssign<any> ;
     * setAssignMethod(obj, 'myProp');
     * setAssignAlias(obj, 'myPropAlias', 'myProp', true); // setting a hard alias.
     * obj.myPropAlias('someValue');
     * const result = obj.toJSON();
     * console.log(result); //{ myProp: 'someValue' }
     * result.myPropAlias // someValue
     */
    function setAssignAlias(obj, propertyName, srcPropertyName, hard) {
        if (hard === void 0) { hard = false; }
        validateMethodName.call(obj, propertyName);
        objectDefinePropertyValue(obj, propertyName, function (value) {
            obj[srcPropertyName](value);
            return obj;
        });
        if (hard === true) {
            var key = privateKey(propertyName), srcKey_1 = privateKey(srcPropertyName);
            Object.defineProperty(obj, key, {
                configurable: false,
                enumerable: false,
                get: function () { return obj[srcKey_1]; }
            });
        }
    }
    /**
     * Represent a fluent API factory wrapper for defining FluentAssign instances.
     */
    var FluentAssignFactory = (function () {
        function FluentAssignFactory(fluentAssign) {
            this._fluentAssign =
                fluentAssign instanceof FluentAssign ? fluentAssign : new FluentAssign();
        }
        /**
         * Create a setter method on the FluentAssign instance.
         * @param name The name of the setter function.
         * @param defaultValue If set (not undefined) set's the value on the instance immediately.
         * @returns {FluentAssignFactory}
         */
        FluentAssignFactory.prototype.setMethod = function (name, defaultValue) {
            if (defaultValue === void 0) { defaultValue = undefined; }
            setAssignMethod(this._fluentAssign, name);
            if (defaultValue !== undefined) {
                this._fluentAssign[name](defaultValue);
            }
            return this;
        };
        Object.defineProperty(FluentAssignFactory.prototype, "fluentAssign", {
            /**
             * The FluentAssign instance.
             * @returns {FluentAssign<T>}
             */
            get: function () {
                return this._fluentAssign;
            },
            enumerable: true,
            configurable: true
        });
        return FluentAssignFactory;
    }());
    /**
     * Represent an object where every property is a function representing an assignment function.
     * Calling each function with a value will assign the value to the object and return the object.
     * Calling 'toJSON' returns an object with the same properties but this time representing the
     * assigned values.
     *
     * This allows setting an object in a fluent API manner.
     * Example:
     let fluent = new FluentAssign<any>(undefined, ['some', 'went']);
     fluent.some('thing').went('wrong').toJSON();
     // { some: 'thing', went: 'wrong' }
     */
    var FluentAssign = (function () {
        /**
         *
         * @param defaultValues An object representing default values for the underlying object.
         * @param initialSetters A list of initial setters for this FluentAssign.
         * @param baseType the class/type to create a new base. optional, {} is used if not supplied.
         */
        function FluentAssign(defaultValues, initialSetters, baseType) {
            var _this = this;
            if (defaultValues === void 0) { defaultValues = undefined; }
            if (initialSetters === void 0) { initialSetters = undefined; }
            if (baseType === void 0) { baseType = undefined; }
            if (Array.isArray(defaultValues)) {
                defaultValues.forEach(function (d) { return applyDefaultValues(_this, d); });
            }
            else if (defaultValues) {
                applyDefaultValues(this, defaultValues);
            }
            if (Array.isArray(initialSetters)) {
                initialSetters.forEach(function (name) { return setAssignMethod(_this, name); });
            }
            if (baseType) {
                this.__fluent$base__ = baseType;
            }
        }
        /**
         * Returns a FluentAssignFactory<FluentAssign<T>> ready to define a FluentAssign type.
         * @param defaultValues An object representing default values for the instance.
         * @param initialSetters A list of initial setters for the instance.
         * @returns {FluentAssignFactory<T>}
         */
        FluentAssign.compose = function (defaultValues, initialSetters) {
            if (defaultValues === void 0) { defaultValues = undefined; }
            if (initialSetters === void 0) { initialSetters = undefined; }
            return FluentAssign.composeWith(new FluentAssign(defaultValues, initialSetters));
        };
        /**
         * Returns a FluentAssignFactory<Z> where Z is an instance of FluentAssign<?> or a derived
         * class of it.
         * @param fluentAssign An instance of FluentAssign<?> or a derived class of FluentAssign<?>.
         * @returns {any}
         */
        FluentAssign.composeWith = function (fluentAssign) {
            return new FluentAssignFactory(fluentAssign);
        };
        FluentAssign.prototype.toJSON = function () {
            var _this = this;
            return getAssignedPropertyNames(this)
                .reduce(function (obj, name) {
                var key = privateKey(name);
                // re-define property descriptors (we dont want their value)
                var propDesc = Object.getOwnPropertyDescriptor(_this, key);
                if (propDesc) {
                    Object.defineProperty(obj, name, propDesc);
                }
                else {
                    obj[name] = _this[key];
                }
                return obj;
            }, this.__fluent$base__ ? new this.__fluent$base__() : {});
        };
        return FluentAssign;
    }());
    /**
     * angular2-modal - Angular2 Modal (dialog) window.
     * @version v2.0.0-beta.2
     * @link https://github.com/shlomiassaf/angular2-modal
     * @license MIT
     */
    /**
     * Simple object extend
     * @param m1
     * @param m2
     * @returns {{}}
     */
    function extend(m1, m2) {
        var m = {};
        for (var attr in m1) {
            if (m1.hasOwnProperty(attr)) {
                m[attr] = m1[attr];
            }
        }
        for (var attr in m2) {
            if (m2.hasOwnProperty(attr)) {
                m[attr] = m2[attr];
            }
        }
        return m;
    }
    /**
     * Simple, not optimized, array union of unique values.
     * @param arr1
     * @param arr2
     * @returns {T[]|any[]|any[][]|any[]}
     */
    function arrayUnion(arr1, arr2) {
        return arr1
            .concat(arr2.filter(function (v) { return arr1.indexOf(v) === -1; }));
    }
    /**
     * Returns true if the config supports a given key.
     * @param key
     * @returns {boolean}
     */
    function supportsKey(keyCode, config) {
        if (!Array.isArray(config))
            return config === null ? false : true;
        return config.indexOf(keyCode) > -1;
    }
    var PromiseCompleter = (function () {
        function PromiseCompleter() {
            var _this = this;
            this.promise = new Promise(function (res, rej) {
                _this.resolve = res;
                _this.reject = rej;
            });
        }
        return PromiseCompleter;
    }());
    function noop() { }
    /**
     * angular2-modal - Angular2 Modal (dialog) window.
     * @version v2.0.0-beta.2
     * @link https://github.com/shlomiassaf/angular2-modal
     * @license MIT
     */
    function createComponent(cfr, type, vcr, bindings) {
        return vcr.createComponent(cfr.resolveComponentFactory(type), vcr.length, getInjector(vcr, bindings));
    }
    function getInjector(viewContainer, bindings) {
        var ctxInjector = viewContainer.parentInjector;
        return Array.isArray(bindings) && bindings.length > 0 ?
            _angular_core.ReflectiveInjector.fromResolvedProviders(bindings, ctxInjector) : ctxInjector;
    }
    /**
     * angular2-modal - Angular2 Modal (dialog) window.
     * @version v2.0.0-beta.2
     * @link https://github.com/shlomiassaf/angular2-modal
     * @license MIT
     */
    var DialogBailOutError = (function (_super) {
        __extends(DialogBailOutError, _super);
        function DialogBailOutError(value) {
            _super.call(this);
            if (!value) {
                value = 'Dialog was forced to close by an unknown source.';
            }
            this.message = value;
        }
        return DialogBailOutError;
    }(Error));
    /**
     * angular2-modal - Angular2 Modal (dialog) window.
     * @version v2.0.0-beta.2
     * @link https://github.com/shlomiassaf/angular2-modal
     * @license MIT
     */
    /**
     * API to an open modal window.
     */
    var DialogRef = (function () {
        function DialogRef(overlay, context) {
            this.overlay = overlay;
            this.context = context;
            this._resultDeferred = new PromiseCompleter();
            this._onDestroy = new rxjs_Subject.Subject();
            this.onDestroy = this._onDestroy.asObservable();
        }
        Object.defineProperty(DialogRef.prototype, "result", {
            /**
             * A Promise that is resolved on a close event and rejected on a dismiss event.
             * @returns {Promise<T>|any|*|Promise<any>}
             */
            get: function () {
                return this._resultDeferred.promise;
            },
            enumerable: true,
            configurable: true
        });
        /**
         * Set a close/dismiss guard
         * @param g
         */
        DialogRef.prototype.setCloseGuard = function (guard) {
            this.closeGuard = guard;
        };
        /**
         *  Close the modal with a return value, i.e: result.
         */
        DialogRef.prototype.close = function (result) {
            var _this = this;
            if (result === void 0) { result = null; }
            var _close = function () {
                _this.destroy();
                _this._resultDeferred.resolve(result);
            };
            this._fireHook('beforeClose')
                .then(function (value) { return value !== true && _close(); })
                .catch(_close);
        };
        /**
         *  Close the modal without a return value, i.e: cancelled.
         *  This call is automatically invoked when a user either:
         *  - Presses an exit keyboard key (if configured).
         *  - Clicks outside of the modal window (if configured).
         *  Usually, dismiss represent a Cancel button or a X button.
         */
        DialogRef.prototype.dismiss = function () {
            var _this = this;
            var _dismiss = function () {
                _this.destroy();
                _this._resultDeferred.reject();
            };
            this._fireHook('beforeDismiss')
                .then(function (value) { return value !== true && _dismiss(); })
                .catch(_dismiss);
        };
        /**
         * Gracefully close the overlay/dialog with a rejected result.
         * Does not trigger canDestroy on the overlay.
         */
        DialogRef.prototype.bailOut = function () {
            if (this.destroyed !== true) {
                this.destroyed = true;
                this._onDestroy.next(null);
                this._onDestroy.complete();
                this._resultDeferred.reject(new DialogBailOutError());
            }
        };
        DialogRef.prototype.destroy = function () {
            var _this = this;
            if (this.destroyed !== true) {
                this.destroyed = true;
                this._onDestroy.next(null);
                this._onDestroy.complete();
                if (typeof this.overlayRef.instance.canDestroy === 'function') {
                    this.overlayRef.instance.canDestroy()
                        .catch(function () { })
                        .then(function () { return _this.overlayRef.destroy(); });
                }
                else {
                    this.overlayRef.destroy();
                }
            }
        };
        DialogRef.prototype._fireHook = function (name) {
            var gurad = this.closeGuard, fn = gurad && typeof gurad[name] === 'function' && gurad[name];
            return Promise.resolve(fn ? fn.call(gurad) : false);
        };
        return DialogRef;
    }());
    /**
     * angular2-modal - Angular2 Modal (dialog) window.
     * @version v2.0.0-beta.2
     * @link https://github.com/shlomiassaf/angular2-modal
     * @license MIT
     */
    (function (DROP_IN_TYPE) {
        DROP_IN_TYPE[DROP_IN_TYPE["alert"] = 0] = "alert";
        DROP_IN_TYPE[DROP_IN_TYPE["prompt"] = 1] = "prompt";
        DROP_IN_TYPE[DROP_IN_TYPE["confirm"] = 2] = "confirm";
    })(exports.DROP_IN_TYPE || (exports.DROP_IN_TYPE = {}));
    var OverlayRenderer = (function () {
        function OverlayRenderer() {
        }
        return OverlayRenderer;
    }());
    /**
     * angular2-modal - Angular2 Modal (dialog) window.
     * @version v2.0.0-beta.2
     * @link https://github.com/shlomiassaf/angular2-modal
     * @license MIT
     */
    var vcRefCollection = {};
    function getVCRef(key) {
        return vcRefCollection[key] ? vcRefCollection[key].slice() : [];
    }
    function setVCRef(key, vcRef) {
        if (!vcRefCollection.hasOwnProperty(key)) {
            vcRefCollection[key] = [];
        }
        vcRefCollection[key].push(vcRef);
    }
    function delVCRef(key, vcRef) {
        if (!vcRef) {
            vcRefCollection[key] = [];
        }
        else {
            var coll = vcRefCollection[key] || [], idx = coll.indexOf(vcRef);
            if (idx > -1) {
                coll.splice(idx, 1);
            }
        }
    }
    /**
     * A Simple store that holds a reference to ViewContainerRef instances by a user defined key.
     * This, with the OverlayTarget directive makes it easy to block the overlay inside an element
     * without having to use the angular query boilerplate.
     * @type {{
     *  getVCRef: (function(string): ViewContainerRef),
     *  setVCRef: (function(string, ViewContainerRef): void),
     *  delVCRef: (function(string): void)
     *  }}
     */
    var vcRefStore = { getVCRef: getVCRef, setVCRef: setVCRef, delVCRef: delVCRef };
    /**
     * angular2-modal - Angular2 Modal (dialog) window.
     * @version v2.0.0-beta.2
     * @link https://github.com/shlomiassaf/angular2-modal
     * @license MIT
     */
    var __decorate$1 = (undefined && undefined.__decorate) || function (decorators, target, key, desc) {
        var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
        if (typeof Reflect === "object" && typeof Reflect.decorate === "function")
            r = Reflect.decorate(decorators, target, key, desc);
        else
            for (var i = decorators.length - 1; i >= 0; i--)
                if (d = decorators[i])
                    r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
        return (c > 3 && r && Object.defineProperty(target, key, r), r);
    };
    var __metadata$1 = (undefined && undefined.__metadata) || function (k, v) {
        if (typeof Reflect === "object" && typeof Reflect.metadata === "function")
            return Reflect.metadata(k, v);
    };
    /**
     * A directive use to signal the overlay that the host of this directive
     * is a dialog boundary, i.e: over click outside of the element should close the modal
     * (if non blocking)
     */
    exports.OverlayDialogBoundary = (function () {
        function OverlayDialogBoundary(el, dialogRef) {
            if (dialogRef && el.nativeElement) {
                dialogRef.overlayRef.instance.setClickBoundary(el.nativeElement);
            }
        }
        return OverlayDialogBoundary;
    }());
    exports.OverlayDialogBoundary = __decorate$1([
        _angular_core.Directive({
            selector: '[overlayDialogBoundary]'
        }),
        __metadata$1('design:paramtypes', [_angular_core.ElementRef, DialogRef])
    ], exports.OverlayDialogBoundary);
    exports.OverlayTarget = (function () {
        function OverlayTarget(vcRef) {
            this.vcRef = vcRef;
        }
        Object.defineProperty(OverlayTarget.prototype, "targetKey", {
            set: function (value) {
                this._targetKey = value;
                if (value) {
                    vcRefStore.setVCRef(value, this.vcRef);
                }
            },
            enumerable: true,
            configurable: true
        });
        OverlayTarget.prototype.ngOnDestroy = function () {
            if (this._targetKey) {
                vcRefStore.delVCRef(this._targetKey, this.vcRef);
            }
        };
        return OverlayTarget;
    }());
    __decorate$1([
        _angular_core.Input('overlayTarget'),
        __metadata$1('design:type', String),
        __metadata$1('design:paramtypes', [String])
    ], exports.OverlayTarget.prototype, "targetKey", null);
    exports.OverlayTarget = __decorate$1([
        _angular_core.Directive({
            selector: '[overlayTarget]'
        }),
        __metadata$1('design:paramtypes', [_angular_core.ViewContainerRef])
    ], exports.OverlayTarget);
    /**
     * angular2-modal - Angular2 Modal (dialog) window.
     * @version v2.0.0-beta.2
     * @link https://github.com/shlomiassaf/angular2-modal
     * @license MIT
     */
    var BROWSER_PREFIX = ['webkit', 'moz', 'MS', 'o', ''];
    function register(eventName, element, cb) {
        BROWSER_PREFIX.forEach(function (p) {
            element.addEventListener(p ? p + eventName : eventName.toLowerCase(), cb, false);
        });
    }
    /**
     * A base class that expose customisation methods in derived components.
     * Capabilities: Add/Remove styls, Add/Remove classes, listen to animation/transition end event,
     * add components
     */
    var BaseDynamicComponent = (function () {
        function BaseDynamicComponent(sanitizer, el) {
            this.sanitizer = sanitizer;
            this.el = el;
            this.style = {};
            this.styleStr = '';
            this.cssClass = '';
            this.classArray = [];
        }
        BaseDynamicComponent.prototype.activateAnimationListener = function () {
            if (this.animationEnd)
                return;
            this.animationEnd = new rxjs_Subject.Subject();
            this.animationEnd$ = this.animationEnd.asObservable();
            register('TransitionEnd', this.el.nativeElement, this.onEndTransition.bind(this));
            register('AnimationEnd', this.el.nativeElement, this.onEndAnimation.bind(this));
        };
        /**
         * Set a specific inline style on the overlay host element.
         * @param prop The style key
         * @param value The value, undefined to remove
         * @returns {ModalOverlay}
         */
        BaseDynamicComponent.prototype.setStyle = function (prop, value) {
            if (this.style[prop] !== value) {
                if (value === undefined) {
                    delete this.style[prop];
                }
                else {
                    this.style[prop] = value;
                }
                this.applyStyle();
            }
            return this;
        };
        /**
         * Remove's all inline styles from the overlay host element.
         */
        BaseDynamicComponent.prototype.clearStyles = function () {
            this.style = {};
            this.applyStyle();
        };
        BaseDynamicComponent.prototype.addClass = function (css, nextTurn) {
            var _this = this;
            if (nextTurn === void 0) { nextTurn = false; }
            if (typeof css === 'string') {
                css.split(' ').forEach(function (c) { return _this._addClass(c, nextTurn); });
            }
        };
        BaseDynamicComponent.prototype.removeClass = function (css, nextTurn) {
            var _this = this;
            if (nextTurn === void 0) { nextTurn = false; }
            if (typeof css === 'string') {
                css.split(' ').forEach(function (c) { return _this._removeClass(c, nextTurn); });
            }
        };
        BaseDynamicComponent.prototype.ngOnDestroy = function () {
            if (this.animationEnd && !this.animationEnd.isUnsubscribed) {
                this.animationEnd.complete();
            }
        };
        BaseDynamicComponent.prototype.applyStyle = function () {
            this.styleStr = this.sanitizer.bypassSecurityTrustStyle(JSON.stringify(this.style)
                .replace('{', '')
                .replace('}', '')
                .replace(/,/g, ';')
                .replace(/"/g, ''));
        };
        BaseDynamicComponent.prototype.applyClasses = function (nextTurn) {
            var _this = this;
            if (nextTurn === true) {
                if (!this.applyOnNextTurn) {
                    this.applyOnNextTurn = true;
                    setTimeout(function () {
                        _this.applyOnNextTurn = false;
                        _this.applyClasses(false);
                    });
                }
            }
            else {
                this.cssClass = this.classArray.join(' ');
            }
        };
        /**
         * Add a component, supply a view container ref.
         * Note: The components vcRef will result in a sibling.
         * @param type The component to add
         * @param vcRef The container to add to
         * @param bindings Bindings to use (added on top of the ViewContainerRef)
         * @returns {Promise<ComponentRef<any>>}
         */
        BaseDynamicComponent.prototype._addComponent = function (type, vcRef, bindings) {
            var cmpRef = createComponent(vcRef.injector.get(_angular_core.ComponentFactoryResolver), type, vcRef, bindings || []);
            cmpRef.changeDetectorRef.detectChanges();
            return cmpRef;
        };
        BaseDynamicComponent.prototype.onEndTransition = function () {
            if (!this.animationEnd.isUnsubscribed) {
                this.animationEnd.next('transition');
            }
        };
        BaseDynamicComponent.prototype.onEndAnimation = function () {
            if (!this.animationEnd.isUnsubscribed) {
                this.animationEnd.next('animation');
            }
        };
        BaseDynamicComponent.prototype._addClass = function (css, nextTurn) {
            if (nextTurn === void 0) { nextTurn = false; }
            if (this.classArray.indexOf(css) > -1)
                return;
            this.classArray.push(css);
            this.applyClasses(nextTurn);
        };
        BaseDynamicComponent.prototype._removeClass = function (css, nextTurn) {
            if (nextTurn === void 0) { nextTurn = false; }
            var idx = this.classArray.indexOf(css);
            if (idx > -1) {
                this.classArray.splice(idx, 1);
                this.applyClasses(nextTurn);
            }
        };
        return BaseDynamicComponent;
    }());
    /**
     * angular2-modal - Angular2 Modal (dialog) window.
     * @version v2.0.0-beta.2
     * @link https://github.com/shlomiassaf/angular2-modal
     * @license MIT
     */
    var __decorate$3 = (undefined && undefined.__decorate) || function (decorators, target, key, desc) {
        var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
        if (typeof Reflect === "object" && typeof Reflect.decorate === "function")
            r = Reflect.decorate(decorators, target, key, desc);
        else
            for (var i = decorators.length - 1; i >= 0; i--)
                if (d = decorators[i])
                    r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
        return (c > 3 && r && Object.defineProperty(target, key, r), r);
    };
    var __metadata$3 = (undefined && undefined.__metadata) || function (k, v) {
        if (typeof Reflect === "object" && typeof Reflect.metadata === "function")
            return Reflect.metadata(k, v);
    };
    /**
     * Represents the modal backdrop shaped by CSS.
     */
    exports.CSSBackdrop = (function (_super) {
        __extends(CSSBackdrop, _super);
        function CSSBackdrop(el, sanitizer) {
            _super.call(this, sanitizer, el);
            this.activateAnimationListener();
            this.style = {
                position: 'absolute',
                top: 0,
                left: 0,
                width: '100%',
                height: '100%'
            };
            this.applyStyle();
        }
        return CSSBackdrop;
    }(BaseDynamicComponent));
    exports.CSSBackdrop = __decorate$3([
        _angular_core.Component({
            selector: 'css-backdrop',
            host: {
                '[attr.class]': 'cssClass',
                '[attr.style]': 'styleStr'
            },
            encapsulation: _angular_core.ViewEncapsulation.None,
            template: ""
        }),
        __metadata$3('design:paramtypes', [_angular_core.ElementRef, _angular_platformBrowser.DomSanitizationService])
    ], exports.CSSBackdrop);
    /**
     * angular2-modal - Angular2 Modal (dialog) window.
     * @version v2.0.0-beta.2
     * @link https://github.com/shlomiassaf/angular2-modal
     * @license MIT
     */
    var __decorate$4 = (undefined && undefined.__decorate) || function (decorators, target, key, desc) {
        var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
        if (typeof Reflect === "object" && typeof Reflect.decorate === "function")
            r = Reflect.decorate(decorators, target, key, desc);
        else
            for (var i = decorators.length - 1; i >= 0; i--)
                if (d = decorators[i])
                    r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
        return (c > 3 && r && Object.defineProperty(target, key, r), r);
    };
    var __metadata$4 = (undefined && undefined.__metadata) || function (k, v) {
        if (typeof Reflect === "object" && typeof Reflect.metadata === "function")
            return Reflect.metadata(k, v);
    };
    /**
     * A component that acts as a top level container for an open modal window.
     */
    exports.CSSDialogContainer = (function (_super) {
        __extends(CSSDialogContainer, _super);
        function CSSDialogContainer(dialog, el, sanitizer) {
            _super.call(this, sanitizer, el);
            this.dialog = dialog;
            this.tabIndex = -1;
            this.role = 'dialog';
            this.activateAnimationListener();
        }
        CSSDialogContainer.prototype.addComponent = function (type, bindings) {
            return _super.prototype._addComponent.call(this, type, this.vcRef, bindings);
        };
        return CSSDialogContainer;
    }(BaseDynamicComponent));
    __decorate$4([
        _angular_core.ViewChild('modalDialog', { read: _angular_core.ViewContainerRef }),
        __metadata$4('design:type', _angular_core.ViewContainerRef)
    ], exports.CSSDialogContainer.prototype, "vcRef", void 0);
    exports.CSSDialogContainer = __decorate$4([
        _angular_core.Component({
            selector: 'css-dialog-container',
            host: {
                '[attr.tabindex]': 'tabIndex',
                '[attr.role]': 'role',
                '[attr.class]': 'cssClass',
                '[attr.style]': 'styleStr'
            },
            encapsulation: _angular_core.ViewEncapsulation.None,
            template: "<span #modalDialog></span>"
        }),
        __metadata$4('design:paramtypes', [DialogRef, _angular_core.ElementRef, _angular_platformBrowser.DomSanitizationService])
    ], exports.CSSDialogContainer);
    /**
     * angular2-modal - Angular2 Modal (dialog) window.
     * @version v2.0.0-beta.2
     * @link https://github.com/shlomiassaf/angular2-modal
     * @license MIT
     */
    var __decorate$2 = (undefined && undefined.__decorate) || function (decorators, target, key, desc) {
        var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
        if (typeof Reflect === "object" && typeof Reflect.decorate === "function")
            r = Reflect.decorate(decorators, target, key, desc);
        else
            for (var i = decorators.length - 1; i >= 0; i--)
                if (d = decorators[i])
                    r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
        return (c > 3 && r && Object.defineProperty(target, key, r), r);
    };
    var __metadata$2 = (undefined && undefined.__metadata) || function (k, v) {
        if (typeof Reflect === "object" && typeof Reflect.metadata === "function")
            return Reflect.metadata(k, v);
    };
    /**
     * Represents the modal overlay.
     */
    exports.ModalOverlay = (function (_super) {
        __extends(ModalOverlay, _super);
        function ModalOverlay(dialogRef, appRef, el, sanitizer) {
            _super.call(this, sanitizer, el);
            this.dialogRef = dialogRef;
            this.appRef = appRef;
            this.activateAnimationListener();
        }
        /**
         * Performs an ApplicationRef.tick
         *
         */
        ModalOverlay.prototype.tick = function () {
            // this.cdr.markForCheck();
            // this.cdr.detectChanges();
            this.appRef.tick();
            // TODO:
            // Change detection doesn't run after doing some operations in plugins.
            // this function is a workaround for those situations. (see bootstrap/vex modal implementations)
            // strange enough, only ApplicationRef.tick() works, the CDR does not... probably due to
            // the need to trigger from a higher change detector, needs investigation.
        };
        ModalOverlay.prototype.addComponent = function (type, bindings) {
            return _super.prototype._addComponent.call(this, type, this.vcRef, bindings);
        };
        ModalOverlay.prototype.fullscreen = function () {
            this.style = {
                position: 'fixed',
                top: 0,
                left: 0,
                bottom: 0,
                right: 0,
                'z-index': 1500
            };
            this.applyStyle();
        };
        ModalOverlay.prototype.insideElement = function () {
            this.style = {
                position: 'absolute',
                width: '100%',
                height: '100%',
                top: 0,
                left: 0,
                bottom: 0,
                right: 0
            };
            this.applyStyle();
        };
        /**
         * Define an element that click inside it will not trigger modal close.
         * Since events bubble, clicking on a dialog will bubble up to the overlay, a plugin
         * must define an element that represent the dialog, the overlay will make sure no to close when
         * it was clicked.
         * @param element
         */
        ModalOverlay.prototype.setClickBoundary = function (element) {
            var _this = this;
            var target;
            var elListener = function (event) { return target = event.target; };
            var docListener = function (event) {
                if (_this.dialogRef.context.isBlocking || !_this.dialogRef.overlay.isTopMost(_this.dialogRef)) {
                    return;
                }
                var current = event.target;
                // on click, this will hit.
                if (current === target)
                    return;
                // on mouse down -> drag -> release the current might not be 'target', it might be
                // a sibling or a child (i.e: not part of the tree-up direction). It might also be a release
                // outside the dialog... so we compare to the boundary element
                do {
                    if (current === element) {
                        return;
                    }
                } while (current.parentNode && (current = current.parentNode));
                _this.dialogRef.dismiss();
            };
            this.dialogRef.onDestroy.subscribe(function () {
                element.removeEventListener('click', elListener, false);
                element.removeEventListener('touchstart', elListener, false);
                document.removeEventListener('click', docListener, false);
                document.removeEventListener('touchend', docListener, false);
            });
            setTimeout(function () {
                element.addEventListener('mousedown', elListener, false);
                element.addEventListener('touchstart', docListener, false);
                document.addEventListener('click', docListener, false);
                document.addEventListener('touchend', docListener, false);
            });
        };
        /**
         * Temp workaround for animation where destruction of the top level component does not
         * trigger child animations. Solution should be found either in animation module or in design
         * of the modal component tree.
         * @returns {Promise<void>}
         */
        ModalOverlay.prototype.canDestroy = function () {
            var completer = new PromiseCompleter();
            if (!Array.isArray(this.beforeDestroyHandlers)) {
                completer.resolve();
            }
            else {
                // run destroy notification but protect against halt.
                var id_1 = setTimeout(function () {
                    id_1 = null;
                    completer.reject();
                }, 1000);
                var resolve = function () {
                    if (id_1 === null)
                        return;
                    clearTimeout(id_1);
                    completer.resolve();
                };
                Promise.all(this.beforeDestroyHandlers.map(function (fn) { return fn(); }))
                    .then(resolve)
                    .catch(resolve);
            }
            return completer.promise;
        };
        /**
         * A handler running before destruction of the overlay
         * use to delay destruction due to animation.
         * This is part of the workaround for animation, see canDestroy.
         *
         * NOTE: There is no guarantee that the listeners will fire, use dialog.onDestory for that.
         * @param fn
         */
        ModalOverlay.prototype.beforeDestroy = function (fn) {
            if (!this.beforeDestroyHandlers) {
                this.beforeDestroyHandlers = [];
            }
            this.beforeDestroyHandlers.push(fn);
        };
        ModalOverlay.prototype.documentKeypress = function (event) {
            // check that this modal is the last in the stack.
            if (!this.dialogRef.overlay.isTopMost(this.dialogRef))
                return;
            if (supportsKey(event.keyCode, this.dialogRef.context.keyboard)) {
                this.dialogRef.dismiss();
            }
        };
        ModalOverlay.prototype.ngOnDestroy = function () {
            _super.prototype.ngOnDestroy.call(this);
            if (this.dialogRef.destroyed !== true) {
                // if we're here the overlay is destroyed by an external event that is not user invoked.
                // i.e: The user did no call dismiss or close and dialogRef.destroy() did not invoke.
                // this will happen when routing or killing an element containing a blocked overlay (ngIf)
                // we bail out, i.e gracefully shutting down.
                this.dialogRef.bailOut();
            }
        };
        return ModalOverlay;
    }(BaseDynamicComponent));
    __decorate$2([
        _angular_core.ViewChild('vcRef', { read: _angular_core.ViewContainerRef }),
        __metadata$2('design:type', _angular_core.ViewContainerRef)
    ], exports.ModalOverlay.prototype, "vcRef", void 0);
    exports.ModalOverlay = __decorate$2([
        _angular_core.Component({
            selector: 'modal-overlay',
            host: {
                '[attr.style]': 'styleStr',
                '[attr.class]': 'cssClass',
                '(body:keydown)': 'documentKeypress($event)'
            },
            encapsulation: _angular_core.ViewEncapsulation.None,
            template: "<span #vcRef></span>"
        }),
        __metadata$2('design:paramtypes', [DialogRef, _angular_core.ApplicationRef, _angular_core.ElementRef, _angular_platformBrowser.DomSanitizationService])
    ], exports.ModalOverlay);
    /**
     * angular2-modal - Angular2 Modal (dialog) window.
     * @version v2.0.0-beta.2
     * @link https://github.com/shlomiassaf/angular2-modal
     * @license MIT
     */
    /**
     * A dumb stack implementation over an array.
     */
    var DialogRefStack = (function () {
        function DialogRefStack() {
            this._stack = [];
        }
        DialogRefStack.prototype.push = function (dialogRef) {
            var idx = this._stack.indexOf(dialogRef);
            if (idx === -1)
                this._stack.push(dialogRef);
        };
        /**
         * Push a DialogRef into the stack and manage it so when it's done
         * it will automatically kick itself out of the stack.
         * @param dialogRef
         */
        DialogRefStack.prototype.pushManaged = function (dialogRef) {
            this.push(dialogRef);
        };
        DialogRefStack.prototype.pop = function () {
            this._stack.pop();
        };
        /**
         * Remove a DialogRef from the stack.
         * @param dialogRef
         */
        DialogRefStack.prototype.remove = function (dialogRef) {
            var idx = this._stack.indexOf(dialogRef);
            if (idx > -1)
                this._stack.splice(idx, 1);
        };
        DialogRefStack.prototype.index = function (index) {
            return this._stack[index];
        };
        DialogRefStack.prototype.indexOf = function (dialogRef) {
            return this._stack.indexOf(dialogRef);
        };
        Object.defineProperty(DialogRefStack.prototype, "length", {
            get: function () {
                return this._stack.length;
            },
            enumerable: true,
            configurable: true
        });
        return DialogRefStack;
    }());
    /**
     * angular2-modal - Angular2 Modal (dialog) window.
     * @version v2.0.0-beta.2
     * @link https://github.com/shlomiassaf/angular2-modal
     * @license MIT
     */
    var __decorate$5 = (undefined && undefined.__decorate) || function (decorators, target, key, desc) {
        var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
        if (typeof Reflect === "object" && typeof Reflect.decorate === "function")
            r = Reflect.decorate(decorators, target, key, desc);
        else
            for (var i = decorators.length - 1; i >= 0; i--)
                if (d = decorators[i])
                    r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
        return (c > 3 && r && Object.defineProperty(target, key, r), r);
    };
    var __metadata$5 = (undefined && undefined.__metadata) || function (k, v) {
        if (typeof Reflect === "object" && typeof Reflect.metadata === "function")
            return Reflect.metadata(k, v);
    };
    var _stack = new DialogRefStack();
    exports.Overlay = (function () {
        function Overlay(_modalRenderer) {
            this._modalRenderer = _modalRenderer;
        }
        Object.defineProperty(Overlay.prototype, "stackLength", {
            get: function () {
                return _stack.length;
            },
            enumerable: true,
            configurable: true
        });
        /**
         * Check if a given DialogRef is the top most ref in the stack.
         * TODO: distinguish between body modal vs in element modal.
         * @param dialogRef
         * @returns {boolean}
         */
        Overlay.prototype.isTopMost = function (dialogRef) {
            return _stack.indexOf(dialogRef) === _stack.length - 1;
        };
        Overlay.prototype.stackPosition = function (dialogRef) {
            return _stack.indexOf(dialogRef);
        };
        /**
         * Opens a modal window inside an existing component.
         */
        Overlay.prototype.open = function (config) {
            var _this = this;
            var viewContainer = config.viewContainer, containers = [];
            if (typeof viewContainer === 'string') {
                containers = vcRefStore.getVCRef(viewContainer);
            }
            else if (Array.isArray(viewContainer)) {
                containers = viewContainer;
            }
            else if (viewContainer) {
                containers = [viewContainer];
            }
            if (!containers || !containers[0]) {
                if (!this.defaultViewContainer) {
                    throw new Error('defaultViewContainer not set.');
                }
                containers = [this.defaultViewContainer];
            }
            return containers.map(function (vc) { return _this.createOverlay(config.renderer || _this._modalRenderer, vc, config); });
        };
        Overlay.prototype.createOverlay = function (renderer, vcRef, config) {
            if (config.context) {
                config.context.normalize();
            }
            var dialog = new DialogRef(this, config.context || {});
            dialog.inElement = !!config.inside;
            var cmpRef = renderer.render(dialog, vcRef);
            Object.defineProperty(dialog, 'overlayRef', { value: cmpRef });
            _stack.pushManaged(dialog);
            dialog.onDestroy.subscribe(function () { return _stack.remove(dialog); });
            return dialog;
        };
        return Overlay;
    }());
    exports.Overlay = __decorate$5([
        _angular_core.Injectable(),
        __metadata$5('design:paramtypes', [OverlayRenderer])
    ], exports.Overlay);
    /**
     * angular2-modal - Angular2 Modal (dialog) window.
     * @version v2.0.0-beta.2
     * @link https://github.com/shlomiassaf/angular2-modal
     * @license MIT
     */
    var __decorate = (undefined && undefined.__decorate) || function (decorators, target, key, desc) {
        var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
        if (typeof Reflect === "object" && typeof Reflect.decorate === "function")
            r = Reflect.decorate(decorators, target, key, desc);
        else
            for (var i = decorators.length - 1; i >= 0; i--)
                if (d = decorators[i])
                    r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
        return (c > 3 && r && Object.defineProperty(target, key, r), r);
    };
    var __metadata = (undefined && undefined.__metadata) || function (k, v) {
        if (typeof Reflect === "object" && typeof Reflect.metadata === "function")
            return Reflect.metadata(k, v);
    };
    exports.DOMOverlayRenderer = (function () {
        function DOMOverlayRenderer(_cr) {
            this._cr = _cr;
        }
        DOMOverlayRenderer.prototype.render = function (dialog, vcRef) {
            var b = _angular_core.ReflectiveInjector.resolve([
                { provide: DialogRef, useValue: dialog }
            ]);
            var cmpRef = createComponent(this._cr, exports.ModalOverlay, vcRef, b);
            if (dialog.inElement) {
                vcRef.element.nativeElement.appendChild(cmpRef.location.nativeElement);
            }
            else {
                document.body.appendChild(cmpRef.location.nativeElement);
            }
            return cmpRef;
        };
        return DOMOverlayRenderer;
    }());
    exports.DOMOverlayRenderer = __decorate([
        _angular_core.Injectable(),
        __metadata('design:paramtypes', [_angular_core.ComponentFactoryResolver])
    ], exports.DOMOverlayRenderer);
    /**
     * angular2-modal - Angular2 Modal (dialog) window.
     * @version v2.0.0-beta.2
     * @link https://github.com/shlomiassaf/angular2-modal
     * @license MIT
     */
    var UnsupportedDropInError = (function (_super) {
        __extends(UnsupportedDropInError, _super);
        function UnsupportedDropInError(dropInName) {
            _super.call(this);
            this.message = "Unsupported Drop-In " + dropInName;
        }
        return UnsupportedDropInError;
    }(Error));
    var Modal = (function () {
        function Modal(overlay) {
            this.overlay = overlay;
        }
        Modal.prototype.alert = function () {
            throw new UnsupportedDropInError('alert');
        };
        Modal.prototype.prompt = function () {
            throw new UnsupportedDropInError('prompt');
        };
        Modal.prototype.confirm = function () {
            throw new UnsupportedDropInError('confirm');
        };
        /**
         * Opens a modal window inside an existing component.
         * @param componentType The angular Component to render as the modal content.
         * @param config Additional settings.
         * @returns {Promise<DialogRef>}
         */
        Modal.prototype.open = function (componentType, config) {
            config = config || {};
            try {
                var dialogs = this.overlay.open(config);
                if (dialogs.length > 1) {
                    console.warn("Attempt to open more then 1 overlay detected.\n        Multiple modal copies are not supported at the moment, \n        only the first viewContainer will display.");
                }
                // TODO:  Currently supporting 1 view container, hence working on dialogs[0].
                //        upgrade to multiple containers.
                return Promise.resolve(this.create(dialogs[0], componentType, config.bindings));
            }
            catch (e) {
                return Promise.reject(e);
            }
        };
        /**
         * A helper function for derived classes to create backdrop & container
         * @param dialogRef
         * @param backdrop
         * @param container
         * @returns { backdropRef: ComponentRef<B>, containerRef: ComponentRef<C> }
         */
        Modal.prototype.createModal = function (dialogRef, backdrop, container) {
            var b = _angular_core.ReflectiveInjector.resolve([{ provide: DialogRef, useValue: dialogRef }]);
            return {
                backdropRef: dialogRef.overlayRef.instance.addComponent(backdrop, b),
                containerRef: dialogRef.overlayRef.instance.addComponent(container, b)
            };
        };
        return Modal;
    }());
    /**
     * angular2-modal - Angular2 Modal (dialog) window.
     * @version v2.0.0-beta.2
     * @link https://github.com/shlomiassaf/angular2-modal
     * @license MIT
     */
    // heavily inspired by:
    // http://www.bennadel.com/blog/3025-creating-custom-dom-and-host-event-bindings-in-angular-2-beta-6.htm
    var __decorate$6 = (undefined && undefined.__decorate) || function (decorators, target, key, desc) {
        var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
        if (typeof Reflect === "object" && typeof Reflect.decorate === "function")
            r = Reflect.decorate(decorators, target, key, desc);
        else
            for (var i = decorators.length - 1; i >= 0; i--)
                if (d = decorators[i])
                    r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
        return (c > 3 && r && Object.defineProperty(target, key, r), r);
    };
    var __metadata$6 = (undefined && undefined.__metadata) || function (k, v) {
        if (typeof Reflect === "object" && typeof Reflect.metadata === "function")
            return Reflect.metadata(k, v);
    };
    var eventMap = {
        clickOutside: 'click',
        mousedownOutside: 'mousedown',
        mouseupOutside: 'mouseup',
        mousemoveOutside: 'mousemove'
    };
    /**
     * An event handler factory for event handlers that bubble the event to a given handler
     * if the event target is not an ancestor of the given element.
     * @param element
     * @param handler
     * @returns {function(any): undefined}
     */
    function bubbleNonAncestorHandlerFactory(element, handler) {
        return function (event) {
            var current = event.target;
            do {
                if (current === element) {
                    return;
                }
            } while (current.parentNode && (current = current.parentNode));
            handler(event);
        };
    }
    var DOMOutsideEventPlugin = (function () {
        function DOMOutsideEventPlugin() {
            // TODO: use DI factory for this.
            if (!document || typeof document.addEventListener !== 'function') {
                this.addEventListener = noop;
            }
        }
        DOMOutsideEventPlugin.prototype.supports = function (eventName) {
            return eventMap.hasOwnProperty(eventName);
        };
        DOMOutsideEventPlugin.prototype.addEventListener = function (element, eventName, handler) {
            var zone = this.manager.getZone();
            // A Factory that registers the event on the document, instead of the element.
            // the handler is created at runtime, and it acts as a propagation/bubble predicate, it will
            // bubble up the event (i.e: execute our original event handler) only if the event targer
            // is an ancestor of our element.
            // The event is fired inside the angular zone so change detection can kick into action.
            var onceOnOutside = function () {
                var listener = bubbleNonAncestorHandlerFactory(element, function (evt) { return zone.runGuarded(function () { return handler(evt); }); });
                // mimic BrowserDomAdapter.onAndCancel
                document.addEventListener(eventMap[eventName], listener, false);
                return function () { return document.removeEventListener(eventMap[eventName], listener, false); };
            };
            // we run the event registration for the document in a different zone, this will make sure
            // change detection is off.
            // It turns out that if a component that use DOMOutsideEventPlugin is built from a click
            // event, we might get here before the event reached the document, causing a quick false
            // positive handling (when stopPropagation() was'nt invoked). To workaround this we wait
            // for the next vm turn and register.
            // Event registration returns a dispose function for that event, angular use it to clean
            // up after component get's destroyed. Since we need to return a dispose function
            // synchronously we have to put a wrapper for it since we will get it asynchronously,
            // i.e: after we need to return it.
            //
            return zone.runOutsideAngular(function () {
                var fn;
                setTimeout(function () { return fn = onceOnOutside(); }, 0);
                return function () { return fn(); };
            });
        };
        DOMOutsideEventPlugin.prototype.addGlobalEventListener = function (target, eventName, handler) {
            throw 'not supported';
        };
        return DOMOutsideEventPlugin;
    }());
    DOMOutsideEventPlugin = __decorate$6([
        _angular_core.Injectable(),
        __metadata$6('design:paramtypes', [])
    ], DOMOutsideEventPlugin);
    /**
     * angular2-modal - Angular2 Modal (dialog) window.
     * @version v2.0.0-beta.2
     * @link https://github.com/shlomiassaf/angular2-modal
     * @license MIT
     */
    var __decorate$7 = (undefined && undefined.__decorate) || function (decorators, target, key, desc) {
        var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
        if (typeof Reflect === "object" && typeof Reflect.decorate === "function")
            r = Reflect.decorate(decorators, target, key, desc);
        else
            for (var i = decorators.length - 1; i >= 0; i--)
                if (d = decorators[i])
                    r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
        return (c > 3 && r && Object.defineProperty(target, key, r), r);
    };
    var __metadata$7 = (undefined && undefined.__metadata) || function (k, v) {
        if (typeof Reflect === "object" && typeof Reflect.metadata === "function")
            return Reflect.metadata(k, v);
    };
    var DEFAULT_VALUES = {
        isBlocking: true,
        keyboard: [27],
        supportsKey: function supportsKey(keyCode) {
            return this.keyboard.indexOf(keyCode) > -1;
        }
    };
    var DEFAULT_SETTERS = [
        'isBlocking',
        'keyboard'
    ];
    var OverlayContext = (function () {
        function OverlayContext() {
        }
        OverlayContext.prototype.normalize = function () {
            if (this.isBlocking !== false)
                this.isBlocking = true;
            if (this.keyboard === null) {
                this.keyboard = [];
            }
            else if (typeof this.keyboard === 'number') {
                this.keyboard = [this.keyboard];
            }
            else if (!Array.isArray(this.keyboard)) {
                this.keyboard = DEFAULT_VALUES.keyboard;
            }
        };
        return OverlayContext;
    }());
    /**
     * A core context builder for a modal window instance, used to define the context upon
     * a modal choose it's behaviour.
     */
    exports.OverlayContextBuilder = (function (_super) {
        __extends(OverlayContextBuilder, _super);
        function OverlayContextBuilder(defaultValues, initialSetters, baseType) {
            if (defaultValues === void 0) { defaultValues = undefined; }
            if (initialSetters === void 0) { initialSetters = undefined; }
            if (baseType === void 0) { baseType = undefined; }
            _super.call(this, extend(DEFAULT_VALUES, defaultValues || {}), arrayUnion(DEFAULT_SETTERS, initialSetters || []), baseType);
        }
        return OverlayContextBuilder;
    }(FluentAssign));
    exports.OverlayContextBuilder = __decorate$7([
        _angular_core.Injectable(),
        __metadata$7('design:paramtypes', [Object, Array, Function])
    ], exports.OverlayContextBuilder);
    /**
     * angular2-modal - Angular2 Modal (dialog) window.
     * @version v2.0.0-beta.2
     * @link https://github.com/shlomiassaf/angular2-modal
     * @license MIT
     */
    var __decorate$8 = (undefined && undefined.__decorate) || function (decorators, target, key, desc) {
        var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
        if (typeof Reflect === "object" && typeof Reflect.decorate === "function")
            r = Reflect.decorate(decorators, target, key, desc);
        else
            for (var i = decorators.length - 1; i >= 0; i--)
                if (d = decorators[i])
                    r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
        return (c > 3 && r && Object.defineProperty(target, key, r), r);
    };
    var __metadata$8 = (undefined && undefined.__metadata) || function (k, v) {
        if (typeof Reflect === "object" && typeof Reflect.metadata === "function")
            return Reflect.metadata(k, v);
    };
    var DEFAULT_VALUES$1 = {};
    var DEFAULT_SETTERS$1 = [
        'message'
    ];
    var ModalContext = (function (_super) {
        __extends(ModalContext, _super);
        function ModalContext() {
            _super.apply(this, arguments);
        }
        return ModalContext;
    }(OverlayContext));
    /**
     * A core context builder for a modal window instance, used to define the context upon
     * a modal choose it's behaviour.
     */
    exports.ModalContextBuilder = (function (_super) {
        __extends(ModalContextBuilder, _super);
        function ModalContextBuilder(defaultValues, initialSetters, baseType) {
            if (defaultValues === void 0) { defaultValues = undefined; }
            if (initialSetters === void 0) { initialSetters = undefined; }
            if (baseType === void 0) { baseType = undefined; }
            _super.call(this, extend(DEFAULT_VALUES$1, defaultValues || {}), arrayUnion(DEFAULT_SETTERS$1, initialSetters || []), baseType);
        }
        return ModalContextBuilder;
    }(exports.OverlayContextBuilder));
    exports.ModalContextBuilder = __decorate$8([
        _angular_core.Injectable(),
        __metadata$8('design:paramtypes', [Object, Array, Function])
    ], exports.ModalContextBuilder);
    /**
     * angular2-modal - Angular2 Modal (dialog) window.
     * @version v2.0.0-beta.2
     * @link https://github.com/shlomiassaf/angular2-modal
     * @license MIT
     */
    var DEFAULT_SETTERS$2 = [
        'component'
    ];
    var ModalOpenContext = (function (_super) {
        __extends(ModalOpenContext, _super);
        function ModalOpenContext() {
            _super.apply(this, arguments);
        }
        return ModalOpenContext;
    }(ModalContext));
    /**
     * A Modal Context that knows about the modal service, and so can open a modal window on demand.
     * Use the fluent API to configure the preset and then invoke the 'open' method to open a modal
     * based on the context.
     */
    var ModalOpenContextBuilder = (function (_super) {
        __extends(ModalOpenContextBuilder, _super);
        function ModalOpenContextBuilder(defaultValues, initialSetters, baseType) {
            if (defaultValues === void 0) { defaultValues = undefined; }
            if (initialSetters === void 0) { initialSetters = undefined; }
            if (baseType === void 0) { baseType = undefined; }
            _super.call(this, defaultValues || {}, arrayUnion(DEFAULT_SETTERS$2, initialSetters || []), baseType);
        }
        /**
         * Hook to alter config and return bindings.
         * @param config
         */
        ModalOpenContextBuilder.prototype.$$beforeOpen = function (config) {
            return [];
        };
        /**
         * Open a modal window based on the configuration of this config instance.
         * @param viewContainer If set opens the modal inside the supplied viewContainer
         * @returns Promise<DialogRef>
         */
        ModalOpenContextBuilder.prototype.open = function (viewContainer) {
            var context = this.toJSON();
            if (!(context.modal instanceof Modal)) {
                return Promise.reject(new Error('Configuration Error: modal service not set.'));
            }
            var overlayConfig = {
                context: context,
                viewContainer: viewContainer,
                bindings: typeof this.$$beforeOpen === 'function' && this.$$beforeOpen(context)
            };
            return context.modal.open(context.component, overlayConfig);
        };
        return ModalOpenContextBuilder;
    }(exports.ModalContextBuilder));
    /**
     * angular2-modal - Angular2 Modal (dialog) window.
     * @version v2.0.0-beta.2
     * @link https://github.com/shlomiassaf/angular2-modal
     * @license MIT
     */
    var __decorate$9 = (undefined && undefined.__decorate) || function (decorators, target, key, desc) {
        var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
        if (typeof Reflect === "object" && typeof Reflect.decorate === "function")
            r = Reflect.decorate(decorators, target, key, desc);
        else
            for (var i = decorators.length - 1; i >= 0; i--)
                if (d = decorators[i])
                    r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
        return (c > 3 && r && Object.defineProperty(target, key, r), r);
    };
    var __metadata$9 = (undefined && undefined.__metadata) || function (k, v) {
        if (typeof Reflect === "object" && typeof Reflect.metadata === "function")
            return Reflect.metadata(k, v);
    };
    var ModalModule_1;
    exports.ModalModule = ModalModule_1 = (function () {
        function ModalModule() {
        }
        ModalModule.forRoot = function () {
            return {
                ngModule: ModalModule_1,
                providers: [
                    exports.Overlay,
                    { provide: OverlayRenderer, useClass: exports.DOMOverlayRenderer },
                    { provide: _angular_platformBrowser.EVENT_MANAGER_PLUGINS, useClass: DOMOutsideEventPlugin, multi: true },
                ]
            };
        };
        return ModalModule;
    }());
    exports.ModalModule = ModalModule_1 = __decorate$9([
        _angular_core.NgModule({
            declarations: [
                exports.ModalOverlay,
                exports.CSSBackdrop,
                exports.CSSDialogContainer,
                exports.OverlayDialogBoundary,
                exports.OverlayTarget
            ],
            exports: [
                exports.CSSBackdrop,
                exports.CSSDialogContainer,
                exports.OverlayDialogBoundary,
                exports.OverlayTarget
            ],
            entryComponents: [
                exports.ModalOverlay,
                exports.CSSBackdrop,
                exports.CSSDialogContainer
            ]
        }),
        __metadata$9('design:paramtypes', [])
    ], exports.ModalModule);
    exports.extend = extend;
    exports.arrayUnion = arrayUnion;
    exports.PromiseCompleter = PromiseCompleter;
    exports.createComponent = createComponent;
    exports.DialogRef = DialogRef;
    exports.OverlayRenderer = OverlayRenderer;
    exports.Modal = Modal;
    exports.OverlayContext = OverlayContext;
    exports.DEFAULT_VALUES = DEFAULT_VALUES$1;
    exports.ModalContext = ModalContext;
    exports.ModalOpenContext = ModalOpenContext;
    exports.ModalOpenContextBuilder = ModalOpenContextBuilder;
    exports.privateKey = privateKey;
    exports.setAssignMethod = setAssignMethod;
    exports.setAssignAlias = setAssignAlias;
    exports.FluentAssignFactory = FluentAssignFactory;
    exports.FluentAssign = FluentAssign;
    exports.DialogBailOutError = DialogBailOutError;
    exports.BaseDynamicComponent = BaseDynamicComponent;
    Object.defineProperty(exports, '__esModule', { value: true });
})));
