/**
 * angular2-modal - Angular2 Modal (dialog) window.
 * @version v2.0.0-beta.2
 * @link https://github.com/shlomiassaf/angular2-modal
 * @license MIT
 */
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return (c > 3 && r && Object.defineProperty(target, key, r), r);
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
import { ComponentFactoryResolver, Injectable, ReflectiveInjector } from '@angular/core';
import createComponent from '../framework/createComponent';
import { DialogRef } from '../models/dialog-ref';
import { ModalOverlay } from '../overlay/index';
export let DOMOverlayRenderer = class DOMOverlayRenderer {
    constructor(_cr) {
        this._cr = _cr;
    }
    render(dialog, vcRef) {
        const b = ReflectiveInjector.resolve([
            { provide: DialogRef, useValue: dialog }
        ]);
        const cmpRef = createComponent(this._cr, ModalOverlay, vcRef, b);
        if (dialog.inElement) {
            vcRef.element.nativeElement.appendChild(cmpRef.location.nativeElement);
        }
        else {
            document.body.appendChild(cmpRef.location.nativeElement);
        }
        return cmpRef;
    }
};
DOMOverlayRenderer = __decorate([
    Injectable(), 
    __metadata('design:paramtypes', [ComponentFactoryResolver])
], DOMOverlayRenderer);

//# sourceMappingURL=dom-modal-renderer.js.map
