var __extends = (this && this.__extends) || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
    function __() { this.constructor = d; }
    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
};
(function (global, factory) {
    typeof exports === 'object' && typeof module !== 'undefined' ? factory(exports, require('rxjs/add/operator/first'), require('@angular/core'), require('angular2-modal'), require('@angular/common')) :
        typeof define === 'function' && define.amd ? define(['exports', 'rxjs/add/operator/first', '@angular/core', 'angular2-modal', '@angular/common'], factory) :
            (factory((global.angular2Modal = global.angular2Modal || {}, global.angular2Modal.plugins = global.angular2Modal.plugins || {}, global.angular2Modal.plugins.vex = global.angular2Modal.plugins.vex || {}), global.rxjs_add_operator_first, global.ng.core, global.angular2 - modal, global.ng.common));
}(this, (function (exports, rxjs_add_operator_first, _angular_core, angular2Modal, _angular_common) {
    'use strict';
    /**
     * angular2-modal - Angular2 Modal (dialog) window.
     * @version v2.0.0-beta.2
     * @link https://github.com/shlomiassaf/angular2-modal
     * @license MIT
     */
    var __decorate$1 = (undefined && undefined.__decorate) || function (decorators, target, key, desc) {
        var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
        if (typeof Reflect === "object" && typeof Reflect.decorate === "function")
            r = Reflect.decorate(decorators, target, key, desc);
        else
            for (var i = decorators.length - 1; i >= 0; i--)
                if (d = decorators[i])
                    r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
        return (c > 3 && r && Object.defineProperty(target, key, r), r);
    };
    var __metadata$1 = (undefined && undefined.__metadata) || function (k, v) {
        if (typeof Reflect === "object" && typeof Reflect.metadata === "function")
            return Reflect.metadata(k, v);
    };
    /**
     * A Dialog is a
     */
    exports.VEXDialogButtons = (function () {
        function VEXDialogButtons() {
            /**
             * Emitted when a button was clicked
             * @type {EventEmitter<VEXButtonClickEvent>}
             */
            this.onButtonClick = new _angular_core.EventEmitter();
        }
        VEXDialogButtons.prototype.onClick = function (btn, $event) {
            $event.stopPropagation();
            this.onButtonClick.emit({ btn: btn, $event: $event });
        };
        return VEXDialogButtons;
    }());
    __decorate$1([
        _angular_core.Input(),
        __metadata$1('design:type', Array)
    ], exports.VEXDialogButtons.prototype, "buttons", void 0);
    __decorate$1([
        _angular_core.Output(),
        __metadata$1('design:type', Object)
    ], exports.VEXDialogButtons.prototype, "onButtonClick", void 0);
    exports.VEXDialogButtons = __decorate$1([
        _angular_core.Component({
            selector: 'vex-dialog-buttons',
            encapsulation: _angular_core.ViewEncapsulation.None,
            template: "<div class=\"vex-dialog-buttons\">\n    <button type=\"button\" \n         *ngFor=\"let btn of buttons;\"\n         [class]=\"btn.cssClass\"\n         (click)=\"onClick(btn, $event)\">{{btn.caption}}</button>\n</div>"
        }),
        __metadata$1('design:paramtypes', [])
    ], exports.VEXDialogButtons);
    /**
     * A Dialog with customized buttons wrapped in a form.
     *
     */
    exports.DialogFormModal = (function () {
        function DialogFormModal(dialog, _cr) {
            this.dialog = dialog;
            this._cr = _cr;
            this.context = dialog.context;
        }
        DialogFormModal.prototype.ngAfterViewInit = function () {
            var _this = this;
            /*  TODO:
             In RC5 dynamic component creation is no longer async.
             Somewhere down the pipe of the created component a value change happens that fires
             a CD exception. setTimeout is a workaround that mimics the async behavior.
             Find out the error and remove setTimeout.
             */
            setTimeout(function () {
                angular2Modal.createComponent(_this._cr, _this.context.content, _this._viewContainer, []);
            });
        };
        DialogFormModal.prototype.onButtonClick = function ($event) {
            $event.btn.onClick(this, $event.$event);
        };
        return DialogFormModal;
    }());
    __decorate$1([
        _angular_core.ViewChild('modalDialog', { read: _angular_core.ViewContainerRef }),
        __metadata$1('design:type', _angular_core.ViewContainerRef)
    ], exports.DialogFormModal.prototype, "_viewContainer", void 0);
    exports.DialogFormModal = __decorate$1([
        _angular_core.Component({
            selector: 'modal-dialog',
            encapsulation: _angular_core.ViewEncapsulation.None,
            template: "<form class=\"vex-dialog-form\">\n    <div style=\"display: none\" #modalDialog></div> \n    <vex-dialog-buttons [buttons]=\"context.buttons\"\n                        (onButtonClick)=\"onButtonClick($event)\"></vex-dialog-buttons>\n</form>"
        }),
        __metadata$1('design:paramtypes', [angular2Modal.DialogRef, _angular_core.ComponentFactoryResolver])
    ], exports.DialogFormModal);
    exports.FormDropIn = (function () {
        function FormDropIn(dialog) {
            this.dialog = dialog;
            this.context = dialog.context;
        }
        return FormDropIn;
    }());
    exports.FormDropIn = __decorate$1([
        _angular_core.Component({
            selector: 'drop-in-dialog',
            encapsulation: _angular_core.ViewEncapsulation.None,
            template: "<div class=\"vex-dialog-message\">{{context.message}}</div>\n <div *ngIf=\"context.showInput\" class=\"vex-dialog-input\">\n   <input #input\n          autofocus\n          name=\"vex\" \n          type=\"text\" \n          class=\"vex-dialog-prompt-input\"\n           (change)=\"context.defaultResult = input.value\" \n          placeholder=\"{{context.placeholder}}\">\n </div>\n <div *ngIf=\"context.showCloseButton\" \n      [class]=\"context.closeClassName\"\n      (click)=\"dialog.dismiss()\"></div>"
        }),
        __metadata$1('design:paramtypes', [angular2Modal.DialogRef])
    ], exports.FormDropIn);
    /**
     * angular2-modal - Angular2 Modal (dialog) window.
     * @version v2.0.0-beta.2
     * @link https://github.com/shlomiassaf/angular2-modal
     * @license MIT
     */
    var DEFAULT_VALUES$1 = {
        className: 'default',
        overlayClassName: 'vex-overlay/index',
        contentClassName: 'vex-content',
        closeClassName: 'vex-close'
    };
    var DEFAULT_SETTERS$2 = [
        'className',
        'overlayClassName',
        'contentClassName',
        'closeClassName',
        'showCloseButton'
    ];
    var VEXModalContext = (function (_super) {
        __extends(VEXModalContext, _super);
        function VEXModalContext() {
            _super.apply(this, arguments);
        }
        return VEXModalContext;
    }(angular2Modal.ModalOpenContext));
    var VEXModalContextBuilder = (function (_super) {
        __extends(VEXModalContextBuilder, _super);
        function VEXModalContextBuilder(defaultValues, initialSetters, baseType) {
            if (defaultValues === void 0) { defaultValues = undefined; }
            if (initialSetters === void 0) { initialSetters = undefined; }
            if (baseType === void 0) { baseType = undefined; }
            _super.call(this, angular2Modal.extend(DEFAULT_VALUES$1, defaultValues || {}), angular2Modal.arrayUnion(DEFAULT_SETTERS$2, initialSetters || []), baseType || VEXModalContext // https://github.com/Microsoft/TypeScript/issues/7234
            );
        }
        /**
         *
         * @aliasFor isBlocking
         */
        VEXModalContextBuilder.prototype.overlayClosesOnClick = function (value) {
            this[angular2Modal.privateKey('isBlocking')] = !value;
            return this;
        };
        return VEXModalContextBuilder;
    }(angular2Modal.ModalOpenContextBuilder));
    /**
     * angular2-modal - Angular2 Modal (dialog) window.
     * @version v2.0.0-beta.2
     * @link https://github.com/shlomiassaf/angular2-modal
     * @license MIT
     */
    var DEFAULT_SETTERS$1 = [
        'content'
    ];
    /**
     * Data definition
     */
    var DialogPreset = (function (_super) {
        __extends(DialogPreset, _super);
        function DialogPreset() {
            _super.apply(this, arguments);
        }
        return DialogPreset;
    }(VEXModalContext));
    /**
     * A Preset representing the configuration needed to open MessageModal.
     * This is an abstract implementation with no concrete behaviour.
     * Use derived implementation.
     */
    var DialogPresetBuilder = (function (_super) {
        __extends(DialogPresetBuilder, _super);
        function DialogPresetBuilder(modal, defaultValues, initialSetters, baseType) {
            if (defaultValues === void 0) { defaultValues = undefined; }
            if (initialSetters === void 0) { initialSetters = undefined; }
            if (baseType === void 0) { baseType = undefined; }
            _super.call(this, angular2Modal.extend({ modal: modal, component: exports.DialogFormModal, buttons: [], defaultResult: true }, defaultValues || {}), angular2Modal.arrayUnion(DEFAULT_SETTERS$1, initialSetters || []), baseType || DialogPreset // https://github.com/Microsoft/TypeScript/issues/7234
            );
        }
        DialogPresetBuilder.prototype.addButton = function (css, caption, onClick) {
            var btn = {
                cssClass: css,
                caption: caption,
                onClick: onClick
            };
            var key = angular2Modal.privateKey('buttons');
            this[key].push(btn);
            return this;
        };
        DialogPresetBuilder.prototype.addOkButton = function (text) {
            if (text === void 0) { text = 'OK'; }
            this.addButton('vex-dialog-button-primary vex-dialog-button vex-first', text, function (cmp, $event) { return cmp.dialog.close(cmp.dialog.context.defaultResult); });
            return this;
        };
        DialogPresetBuilder.prototype.addCancelButton = function (text) {
            if (text === void 0) { text = 'CANCEL'; }
            this.addButton('vex-dialog-button-secondary vex-dialog-button vex-last', text, function (cmp, $event) { return cmp.dialog.dismiss(); });
            return this;
        };
        return DialogPresetBuilder;
    }(VEXModalContextBuilder));
    /**
     * angular2-modal - Angular2 Modal (dialog) window.
     * @version v2.0.0-beta.2
     * @link https://github.com/shlomiassaf/angular2-modal
     * @license MIT
     */
    var DEFAULT_VALUES = {
        component: exports.DialogFormModal,
        content: exports.FormDropIn,
        okBtn: 'OK',
        cancelBtn: 'Cancel'
    };
    var DEFAULT_SETTERS = [
        'okBtn',
        'cancelBtn',
        'placeholder',
        'showCloseButton'
    ];
    /**
     * Data definition
     */
    var DropInPreset = (function (_super) {
        __extends(DropInPreset, _super);
        function DropInPreset() {
            _super.apply(this, arguments);
        }
        Object.defineProperty(DropInPreset.prototype, "showInput", {
            get: function () {
                return this.dropInType === angular2Modal.DROP_IN_TYPE.prompt;
            },
            enumerable: true,
            configurable: true
        });
        return DropInPreset;
    }(DialogPreset));
    /**
     * A Preset representing all 3 drop ins (alert, prompt, confirm)
     */
    var DropInPresetBuilder = (function (_super) {
        __extends(DropInPresetBuilder, _super);
        function DropInPresetBuilder(modal, dropInType, defaultValues) {
            if (defaultValues === void 0) { defaultValues = undefined; }
            _super.call(this, modal, angular2Modal.extend(angular2Modal.extend({ modal: modal, dropInType: dropInType }, DEFAULT_VALUES), defaultValues || {}), DEFAULT_SETTERS, DropInPreset);
        }
        DropInPresetBuilder.prototype.$$beforeOpen = function (config) {
            if (config.okBtn) {
                this.addOkButton(config.okBtn);
            }
            switch (config.dropInType) {
                case angular2Modal.DROP_IN_TYPE.prompt:
                    config.defaultResult = undefined;
                case angular2Modal.DROP_IN_TYPE.confirm:
                    if (config.cancelBtn) {
                        this.addCancelButton(config.cancelBtn);
                    }
                    break;
            }
            return _super.prototype.$$beforeOpen.call(this, config);
        };
        return DropInPresetBuilder;
    }(DialogPresetBuilder));
    /**
     * angular2-modal - Angular2 Modal (dialog) window.
     * @version v2.0.0-beta.2
     * @link https://github.com/shlomiassaf/angular2-modal
     * @license MIT
     */
    var __decorate = (undefined && undefined.__decorate) || function (decorators, target, key, desc) {
        var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
        if (typeof Reflect === "object" && typeof Reflect.decorate === "function")
            r = Reflect.decorate(decorators, target, key, desc);
        else
            for (var i = decorators.length - 1; i >= 0; i--)
                if (d = decorators[i])
                    r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
        return (c > 3 && r && Object.defineProperty(target, key, r), r);
    };
    var __metadata = (undefined && undefined.__metadata) || function (k, v) {
        if (typeof Reflect === "object" && typeof Reflect.metadata === "function")
            return Reflect.metadata(k, v);
    };
    exports.Modal = (function (_super) {
        __extends(Modal, _super);
        function Modal(base) {
            _super.call(this, base);
        }
        Modal.prototype.alert = function () {
            return new DropInPresetBuilder(this, angular2Modal.DROP_IN_TYPE.alert, { isBlocking: false });
        };
        Modal.prototype.prompt = function () {
            return new DropInPresetBuilder(this, angular2Modal.DROP_IN_TYPE.prompt, {
                isBlocking: true,
                keyboard: null
            });
        };
        Modal.prototype.confirm = function () {
            return new DropInPresetBuilder(this, angular2Modal.DROP_IN_TYPE.confirm, {
                isBlocking: true,
                keyboard: null
            });
        };
        Modal.prototype.create = function (dialogRef, type, bindings) {
            var _this = this;
            var refs = this.createModal(dialogRef, angular2Modal.CSSBackdrop, angular2Modal.CSSDialogContainer);
            refs.containerRef.instance.addComponent(type, bindings);
            var overlay = dialogRef.overlayRef.instance;
            var backdrop = refs.backdropRef.instance;
            var container = refs.containerRef.instance;
            dialogRef.inElement ? overlay.insideElement() : overlay.fullscreen();
            // add body class if this is the only dialog in the stack
            if (!document.body.classList.contains('vex-open')) {
                document.body.classList.add('vex-open');
            }
            // on removal, remove if last.
            dialogRef.onDestroy
                .subscribe(function () { return _this.overlay.stackLength === 0 && document.body.classList.remove('vex-open'); });
            overlay.addClass("vex vex-theme-" + dialogRef.context.className);
            backdrop.addClass('vex-overlay');
            container.addClass(dialogRef.context.contentClassName);
            container.setStyle('display', 'block');
            if (dialogRef.inElement) {
                overlay.setStyle('padding', '0');
                container.setStyle('margin-top', '20px');
            }
            if (refs.containerRef.location.nativeElement) {
                refs.containerRef.location.nativeElement.focus();
            }
            overlay.beforeDestroy(function () {
                overlay.addClass('vex-closing');
                // TODO:
                // Change detection doesn't run after removing these classes, not even in 'nextTurn'
                // e.g: backdrop.removeClass('in', true);
                // the only solution is to change immediately and tick the change detection.
                // This happen for every click (unlike bootstrap plugin).
                // oddly using ChangeDetectorRef.detectChanges() doesn't work... ???
                // running inside zone didn't help.
                overlay.tick();
                var completer = new angular2Modal.PromiseCompleter();
                container.animationEnd$.first().subscribe(function (type) { return completer.resolve(); });
                return completer.promise;
            });
            if (dialogRef.context.className === 'bottom-right-corner') {
                overlay.setStyle('overflow-y', 'hidden');
                container.setStyle('position', 'absolute');
            }
            else {
                overlay.beforeDestroy(function () {
                    var completer = new angular2Modal.PromiseCompleter();
                    backdrop.animationEnd$.first().subscribe(function (type) { return completer.resolve(); });
                    return completer.promise;
                });
            }
            overlay.setClickBoundary(refs.containerRef.location.nativeElement);
            return dialogRef;
        };
        return Modal;
    }(angular2Modal.Modal));
    exports.Modal = __decorate([
        _angular_core.Injectable(),
        __metadata('design:paramtypes', [angular2Modal.Overlay])
    ], exports.Modal);
    /**
     * angular2-modal - Angular2 Modal (dialog) window.
     * @version v2.0.0-beta.2
     * @link https://github.com/shlomiassaf/angular2-modal
     * @license MIT
     */
    var __decorate$2 = (undefined && undefined.__decorate) || function (decorators, target, key, desc) {
        var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
        if (typeof Reflect === "object" && typeof Reflect.decorate === "function")
            r = Reflect.decorate(decorators, target, key, desc);
        else
            for (var i = decorators.length - 1; i >= 0; i--)
                if (d = decorators[i])
                    r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
        return (c > 3 && r && Object.defineProperty(target, key, r), r);
    };
    var __metadata$2 = (undefined && undefined.__metadata) || function (k, v) {
        if (typeof Reflect === "object" && typeof Reflect.metadata === "function")
            return Reflect.metadata(k, v);
    };
    function getProviders() {
        return [
            { provide: angular2Modal.Modal, useClass: exports.Modal },
            { provide: exports.Modal, useClass: exports.Modal }
        ];
    }
    exports.VexModalModule = (function () {
        function VexModalModule() {
        }
        VexModalModule.getProviders = function () {
            return getProviders();
        };
        return VexModalModule;
    }());
    exports.VexModalModule = __decorate$2([
        _angular_core.NgModule({
            imports: [angular2Modal.ModalModule, _angular_common.CommonModule],
            declarations: [
                exports.VEXDialogButtons,
                exports.FormDropIn,
                exports.DialogFormModal
            ],
            providers: getProviders(),
            entryComponents: [
                exports.DialogFormModal,
                exports.FormDropIn
            ]
        }),
        __metadata$2('design:paramtypes', [])
    ], exports.VexModalModule);
    exports.VEXModalContext = VEXModalContext;
    exports.VEXModalContextBuilder = VEXModalContextBuilder;
    exports.DropInPreset = DropInPreset;
    exports.DropInPresetBuilder = DropInPresetBuilder;
    exports.DialogPreset = DialogPreset;
    exports.DialogPresetBuilder = DialogPresetBuilder;
    Object.defineProperty(exports, '__esModule', { value: true });
})));
