/**
 * angular2-modal - Angular2 Modal (dialog) window.
 * @version v2.0.0-beta.2
 * @link https://github.com/shlomiassaf/angular2-modal
 * @license MIT
 */
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return (c > 3 && r && Object.defineProperty(target, key, r), r);
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
import { Component, ElementRef, ViewEncapsulation } from '@angular/core';
import { DomSanitizationService } from '@angular/platform-browser';
import { BaseDynamicComponent } from './base-dynamic-component';
/**
 * Represents the modal backdrop shaped by CSS.
 */
export let CSSBackdrop = class CSSBackdrop extends BaseDynamicComponent {
    constructor(el, sanitizer) {
        super(sanitizer, el);
        this.activateAnimationListener();
        this.style = {
            position: 'absolute',
            top: 0,
            left: 0,
            width: '100%',
            height: '100%'
        };
        this.applyStyle();
    }
};
CSSBackdrop = __decorate([
    Component({
        selector: 'css-backdrop',
        host: {
            '[attr.class]': 'cssClass',
            '[attr.style]': 'styleStr'
        },
        encapsulation: ViewEncapsulation.None,
        template: ``
    }), 
    __metadata('design:paramtypes', [ElementRef, DomSanitizationService])
], CSSBackdrop);

//# sourceMappingURL=css-backdrop.js.map
