/**
 * angular2-modal - Angular2 Modal (dialog) window.
 * @version v2.0.0-beta.2
 * @link https://github.com/shlomiassaf/angular2-modal
 * @license MIT
 */
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return (c > 3 && r && Object.defineProperty(target, key, r), r);
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
import { Component, ViewContainerRef, ViewChild, ViewEncapsulation, ElementRef } from '@angular/core';
import { DomSanitizationService } from '@angular/platform-browser';
import { BaseDynamicComponent } from './base-dynamic-component';
import { DialogRef } from '../models/dialog-ref';
/**
 * A component that acts as a top level container for an open modal window.
 */
export let CSSDialogContainer = class CSSDialogContainer extends BaseDynamicComponent {
    constructor(dialog, el, sanitizer) {
        super(sanitizer, el);
        this.dialog = dialog;
        this.tabIndex = -1;
        this.role = 'dialog';
        this.activateAnimationListener();
    }
    addComponent(type, bindings) {
        return super._addComponent(type, this.vcRef, bindings);
    }
};
__decorate([
    ViewChild('modalDialog', { read: ViewContainerRef }), 
    __metadata('design:type', ViewContainerRef)
], CSSDialogContainer.prototype, "vcRef", void 0);
CSSDialogContainer = __decorate([
    Component({
        selector: 'css-dialog-container',
        host: {
            '[attr.tabindex]': 'tabIndex',
            '[attr.role]': 'role',
            '[attr.class]': 'cssClass',
            '[attr.style]': 'styleStr'
        },
        encapsulation: ViewEncapsulation.None,
        template: `<span #modalDialog></span>`
    }), 
    __metadata('design:paramtypes', [DialogRef, ElementRef, DomSanitizationService])
], CSSDialogContainer);

//# sourceMappingURL=css-dialog-container.js.map
