var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
import { combineLatest } from 'rxjs/operator/combineLatest';
import { Injectable } from '@angular/core';
import { Overlay, Modal as Modal_, CSSBackdrop, PromiseCompleter } from 'angular2-modal';
import { BSModalContainer } from './modal-container.component';
import { OneButtonPresetBuilder } from './presets/one-button-preset';
import { TwoButtonPresetBuilder, PromptPresetBuilder } from './presets/two-button-preset';
// TODO: use DI factory for this.
// TODO: consolidate dup code
var /** @type {?} */ isDoc = !(typeof document === 'undefined' || !document);
var Modal = (function (_super) {
    __extends(Modal, _super);
    /**
     * @param {?} overlay
     */
    function Modal(overlay) {
        return _super.call(this, overlay) || this;
    }
    /**
     * @return {?}
     */
    Modal.prototype.alert = function () {
        return new OneButtonPresetBuilder(this, /** @type {?} */ ({ isBlocking: false }));
    };
    /**
     * @return {?}
     */
    Modal.prototype.prompt = function () {
        return new PromptPresetBuilder(this, /** @type {?} */ ({ isBlocking: true, keyboard: null }));
    };
    /**
     * @return {?}
     */
    Modal.prototype.confirm = function () {
        return new TwoButtonPresetBuilder(this, /** @type {?} */ ({ isBlocking: true, keyboard: null }));
    };
    /**
     * @param {?} dialogRef
     * @param {?} content
     * @param {?=} bindings
     * @return {?}
     */
    Modal.prototype.create = function (dialogRef, content, bindings) {
        var _this = this;
        var /** @type {?} */ backdropRef = this.createBackdrop(dialogRef, CSSBackdrop);
        var /** @type {?} */ containerRef = this.createContainer(dialogRef, BSModalContainer, content, bindings);
        var /** @type {?} */ overlay = dialogRef.overlayRef.instance;
        var /** @type {?} */ backdrop = backdropRef.instance;
        var /** @type {?} */ container = containerRef.instance;
        dialogRef.inElement ? overlay.insideElement() : overlay.fullscreen();
        // add body class if this is the only dialog in the stack
        if (isDoc && !document.body.classList.contains('modal-open')) {
            document.body.classList.add('modal-open');
        }
        if (dialogRef.inElement) {
            backdrop.setStyle('position', 'absolute');
        }
        backdrop.addClass('modal-backdrop fade', true);
        backdrop.addClass('in');
        container.addClass('in');
        if (containerRef.location.nativeElement) {
            containerRef.location.nativeElement.focus();
        }
        overlay.beforeDestroy(function () {
            var /** @type {?} */ completer = new PromiseCompleter();
            backdrop.removeClass('in');
            container.removeClass('in');
            combineLatest.call(backdrop.myAnimationEnd$(), container.myAnimationEnd$(), function (s1, s2) { return [s1, s2]; })
                .subscribe(function (sources) {
                isDoc && _this.overlay.groupStackLength(dialogRef) === 1 && document.body.classList.remove('modal-open');
                completer.resolve();
            });
            return completer.promise;
        });
        return dialogRef;
    };
    Modal.decorators = [
        { type: Injectable },
    ];
    /**
     * @nocollapse
     */
    Modal.ctorParameters = function () { return [
        { type: Overlay, },
    ]; };
    return Modal;
}(Modal_));
export { Modal };
function Modal_tsickle_Closure_declarations() {
    /** @type {?} */
    Modal.decorators;
    /**
     * @nocollapse
     * @type {?}
     */
    Modal.ctorParameters;
}
//# sourceMappingURL=modal.js.map