var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
import { extend, arrayUnion } from './../framework/utils';
import { OverlayContext, OverlayContextBuilder } from './overlay-context';
export var /** @type {?} */ DEFAULT_VALUES = {};
var /** @type {?} */ DEFAULT_SETTERS = [
    'message'
];
var ModalContext = (function (_super) {
    __extends(ModalContext, _super);
    function ModalContext() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    return ModalContext;
}(OverlayContext));
export { ModalContext };
function ModalContext_tsickle_Closure_declarations() {
    /**
     * The core message to display.
     * A modal might have an extended message (e.g: HTML message) or other fields (e.g: title) but
     * all models, at core, convey a message thus message is common to all modals.
     * @type {?}
     */
    ModalContext.prototype.message;
}
/**
 * A core context builder for a modal window instance, used to define the context upon
 * a modal choose it's behaviour.
 */
var ModalContextBuilder = (function (_super) {
    __extends(ModalContextBuilder, _super);
    /**
     * @param {?=} defaultValues
     * @param {?=} initialSetters
     * @param {?=} baseType
     */
    function ModalContextBuilder(defaultValues, initialSetters, baseType) {
        if (defaultValues === void 0) { defaultValues = undefined; }
        if (initialSetters === void 0) { initialSetters = undefined; }
        if (baseType === void 0) { baseType = undefined; }
        return _super.call(this, extend(DEFAULT_VALUES, defaultValues || {}), arrayUnion(DEFAULT_SETTERS, initialSetters || []), baseType) || this;
    }
    return ModalContextBuilder;
}(OverlayContextBuilder));
export { ModalContextBuilder };
function ModalContextBuilder_tsickle_Closure_declarations() {
    /**
     * The core message to display.
     * A modal might have an extended message (e.g: HTML message) or other fields (e.g: title) but
     * all models, at core, convey a message thus message is common to all modals.
     * @type {?}
     */
    ModalContextBuilder.prototype.message;
}
//# sourceMappingURL=modal-context.js.map