import { NgZone, EventEmitter } from '@angular/core';
import { Http, XHRConnection, ConnectionBackend, XHRBackend, ReadyState, Request, RequestOptions, Response, ResponseOptions, RequestOptionsArgs, BrowserXhr, XSRFStrategy, JSONPBackend } from '@angular/http';
import { Observable } from 'rxjs/Observable';
import 'rxjs/add/operator/map';
export declare class PreloadHttp extends Http {
    protected _backend: ConnectionBackend;
    protected _defaultOptions: RequestOptions;
    _async: number;
    constructor(_backend: ConnectionBackend, _defaultOptions: RequestOptions);
    preload(_url: any, factory: any): EventEmitter<{}>;
    request(url: string | Request, options?: RequestOptionsArgs): Observable<Response> | EventEmitter<any>;
    get(url: string, options?: RequestOptionsArgs): Observable<Response> | EventEmitter<any>;
    post(url: string, body: string, options?: RequestOptionsArgs): Observable<Response> | EventEmitter<any>;
    put(url: string, body: string, options?: RequestOptionsArgs): Observable<Response> | EventEmitter<any>;
    delete(url: string, options?: RequestOptionsArgs): Observable<Response> | EventEmitter<any>;
    patch(url: string, body: string, options?: RequestOptionsArgs): Observable<Response> | EventEmitter<any>;
    head(url: string, options?: RequestOptionsArgs): Observable<Response> | EventEmitter<any>;
}
export declare class NodeConnection implements XHRConnection {
    readyState: ReadyState;
    request: Request;
    response: Observable<Response> | Observable<any>;
    constructor(req: Request, baseResponseOptions: ResponseOptions, originUrl?: string, baseUrl?: string);
    setDetectedContentType: (req: any, _xhr: any) => void;
}
export declare class NodeBackend extends XHRBackend {
    private baseResponseOptions;
    private _baseUrl;
    private _originUrl;
    constructor(baseResponseOptions: ResponseOptions, _browserXHR: BrowserXhr, _xsrfStrategy: XSRFStrategy, _ngZone: NgZone, _baseUrl: string, _originUrl: string);
    createConnection(request: Request): NodeConnection;
}
export declare class NodeJSONPConnection {
    readyState: ReadyState;
    request: Request;
    response: Observable<Response> | Observable<any>;
    constructor(req: Request, baseResponseOptions: ResponseOptions, ngZone: NgZone, originUrl?: string, baseUrl?: string);
}
export declare abstract class NodeJsonpBackend extends ConnectionBackend {
}
export declare class NodeJsonpBackend_ extends NodeJsonpBackend {
    private _baseResponseOptions;
    private _ngZone;
    private _baseUrl;
    private _originUrl;
    constructor(_baseResponseOptions: ResponseOptions, _ngZone: NgZone, _baseUrl: string, _originUrl: string);
    createConnection(request: Request): NodeJSONPConnection;
}
export declare function _noop(): void;
export declare const NODE_HTTP_PROVIDERS_COMMON: Array<any>;
export declare const NODE_HTTP_PROVIDERS: any[];
export declare const NODE_JSONP_PROVIDERS: any[];
export declare function httpFactory(xhrBackend: XHRBackend, requestOptions: RequestOptions): PreloadHttp;
export declare function jsonpFactory(jsonpBackend: JSONPBackend, requestOptions: RequestOptions): PreloadHttp;
export declare class NodeHttpModule {
    static forRoot(config?: any): {
        ngModule: typeof NodeHttpModule;
        providers: any[];
    };
    static withConfig(config?: any): {
        ngModule: typeof NodeHttpModule;
        providers: any[];
    };
}
export declare class NodeJsonpModule {
    static forRoot(config?: any): {
        ngModule: typeof NodeJsonpModule;
        providers: any[];
    };
    static withConfig(config?: any): {
        ngModule: typeof NodeJsonpModule;
        providers: any[];
    };
}
