"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var core_1 = require("angular2/core");
var TabListComponent = (function () {
    function TabListComponent() {
        this.tabs = [];
        this.listClass = "an-tablist";
    }
    TabListComponent.prototype.onClick = function (ev) {
        this.activateByTab(ev);
    };
    TabListComponent.prototype.activateByTab = function (tab) {
        if (tab !== this.activeTab && tab.canActivate()) {
            if (this.activeTab) {
                this.activeTab.deactivate();
            }
            this.activeTab = tab;
            this.activeTab.activate();
        }
    };
    TabListComponent.prototype.activateByKey = function (key) {
        var tab = this.tabs.filter(function (value) { return value.key === key; });
        if (tab && tab.length > 0) {
            this.onClick(tab[0]);
        }
    };
    __decorate([
        core_1.Input('anListClass'), 
        __metadata('design:type', String)
    ], TabListComponent.prototype, "listClass", void 0);
    TabListComponent = __decorate([
        core_1.Component({
            selector: "an-tablist,[an-tablist]",
            template: "<ul [attr.class]=\"listClass\">\n                  <li class=\"an-tablistitem\" [ngClass]=\"{'an-active': tab.active, 'an-inactive': !tab.active, 'an-canactivate': tab.canActivate(), 'an-cantactivate': !tab.canActivate()}\" *ngFor=\"#tab of tabs\" (click)=\"onClick(tab)\">\n                     {{tab.title}}\n                  </li>\n              </ul>",
            exportAs: "anTabList"
        }), 
        __metadata('design:paramtypes', [])
    ], TabListComponent);
    return TabListComponent;
}());
exports.TabListComponent = TabListComponent;
