"use strict";
var __extends = (this && this.__extends) || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
    function __() { this.constructor = d; }
    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
};
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
var core_1 = require("angular2/core");
var tabs_component_1 = require("./tabs-component");
var AngularNavTab = (function () {
    function AngularNavTab(templateRef, view, anTabs) {
        this.templateRef = templateRef;
        this.view = view;
        this.canActivate = function () { return true; };
        this.active = false;
        this.anTabs = anTabs;
    }
    AngularNavTab.prototype.ngOnInit = function () {
        this.anTabs.list.tabs.push(this);
    };
    Object.defineProperty(AngularNavTab.prototype, "anTab", {
        set: function (value) {
            if (typeof value === 'object') {
                if (value.title) {
                    this.title = value.title;
                }
                else {
                    throw "Title is required if an Object is passed into AngularNavTab";
                }
                if (value.canActivate) {
                    this.canActivate = value.canActivate;
                }
                if (value.id) {
                    this.key = value.id;
                }
                else {
                    this.key = value.title;
                }
            }
            else {
                this.title = value;
                this.key = value;
            }
        },
        enumerable: true,
        configurable: true
    });
    AngularNavTab.prototype.activate = function () {
        if (!this.active) {
            this.view.createEmbeddedView(this.templateRef);
            this.active = true;
        }
    };
    AngularNavTab.prototype.deactivate = function () {
        if (this.active) {
            this.view.clear();
            this.active = false;
        }
    };
    AngularNavTab = __decorate([
        core_1.Directive({
            selector: "[anTab]",
            inputs: ['anTab']
        }),
        __param(2, core_1.Host()), 
        __metadata('design:paramtypes', [core_1.TemplateRef, core_1.ViewContainerRef, tabs_component_1.AngularNavTabs])
    ], AngularNavTab);
    return AngularNavTab;
}());
exports.AngularNavTab = AngularNavTab;
var AngularNavTabDefault = (function (_super) {
    __extends(AngularNavTabDefault, _super);
    function AngularNavTabDefault(templateRef, view, anTabs) {
        _super.call(this, templateRef, view, anTabs);
    }
    AngularNavTabDefault.prototype.ngOnInit = function () {
        _super.prototype.ngOnInit.call(this);
        this.anTabs.list.activateByTab(this);
    };
    Object.defineProperty(AngularNavTabDefault.prototype, "anTabDefault", {
        set: function (value) {
            this.anTab = value;
        },
        enumerable: true,
        configurable: true
    });
    AngularNavTabDefault = __decorate([
        core_1.Directive({
            selector: "[anTabDefault]",
            inputs: ['anTabDefault']
        }),
        __param(2, core_1.Host()), 
        __metadata('design:paramtypes', [core_1.TemplateRef, core_1.ViewContainerRef, tabs_component_1.AngularNavTabs])
    ], AngularNavTabDefault);
    return AngularNavTabDefault;
}(AngularNavTab));
exports.AngularNavTabDefault = AngularNavTabDefault;
