import { DynamicComponentLoader, ChangeDetectorRef } from 'angular2/core';
import { BodyOutputType } from './bodyOutputType';
import { ToasterConfig } from './toaster-config';
import { ToasterService } from './toaster.service';
import { Toast } from './toast';
export declare class ToasterContainerComponent {
    private addToastSubscriber;
    private clearToastsSubscriber;
    private toasterService;
    private dcl;
    private changeDetectorRef;
    private id;
    toasterconfig: ToasterConfig;
    toasts: Toast[];
    bodyOutputType: typeof BodyOutputType;
    constructor(toasterService: ToasterService, dcl: DynamicComponentLoader, changeDetectorRef: ChangeDetectorRef);
    ngOnInit(): void;
    click(toast: Toast, isCloseButton?: boolean): void;
    stopTimer(toast: Toast): void;
    restartTimer(toast: Toast): void;
    private registerSubscribers();
    private addToast(toast);
    private configureTimer(toast);
    private isLimitExceeded();
    private removeToast(toast);
    private removeAllToasts();
    private clearToasts(clearWrapper);
    private clearToastsAction(toastId?);
    ngOnDestroy(): void;
}
