'use strict';

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

var _dec, _class;

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TranslateService = undefined;

var _core = require('angular2/core');

var _flat = require('flat');

var _sprintfJs = require('sprintf-js');

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

var TranslateService = exports.TranslateService = (_dec = (0, _core.Injectable)(), _dec(_class = (function () {
  function TranslateService(translations) {
    _classCallCheck(this, TranslateService);

    this._translations = (0, _flat.flatten)(translations);
  }

  _createClass(TranslateService, [{
    key: 'setTranslations',
    value: function setTranslations(value) {
      this._translations = (0, _flat.flatten)(value);
    }
  }, {
    key: 'translate',
    value: function translate(value) {
      var parameters = arguments.length <= 1 || arguments[1] === undefined ? [] : arguments[1];

      var translated = this._translations[value] ? this._translations[value] : value;
      try {
        return (0, _sprintfJs.vsprintf)(translated, parameters);
      } catch (e) {
        return value.replace(/%s|%d/gi, '');
      }
    }
  }]);

  return TranslateService;
})()) || _class);
(0, _core.Inject)('translations')(TranslateService, null, 0);
//# sourceMappingURL=service.js.map