"use strict";
var core_1 = require('@angular/core');
var tree_node_drag_model_1 = require('../models/tree-node-drag.model');
var DRAG_OVER_CLASS = 'is-dragging-over';
var TreeNodeDrop = (function () {
    function TreeNodeDrop(el, renderer, treeNodeDrag) {
        this.el = el;
        this.renderer = renderer;
        this.treeNodeDrag = treeNodeDrag;
    }
    TreeNodeDrop.prototype.onDragOver = function ($event) {
        $event.preventDefault();
        this.addClass();
    };
    TreeNodeDrop.prototype.onDragLeave = function ($event) {
        var rect = this.el.nativeElement.getBoundingClientRect();
        // If outside the element
        if ($event.clientX < rect.left || $event.clientX > rect.right ||
            $event.clientY < rect.top || $event.clientY > rect.bottom) {
            this.removeClass();
        }
    };
    TreeNodeDrop.prototype.onDrop = function ($event) {
        $event.preventDefault();
        this.treeNodeDrop({ event: $event, node: this.treeNodeDrag.getDragNode() });
        this.removeClass();
    };
    TreeNodeDrop.prototype.addClass = function () {
        this.renderer.setElementClass(this.el.nativeElement, DRAG_OVER_CLASS, true);
    };
    TreeNodeDrop.prototype.removeClass = function () {
        this.renderer.setElementClass(this.el.nativeElement, DRAG_OVER_CLASS, false);
    };
    TreeNodeDrop.decorators = [
        { type: core_1.Directive, args: [{
                    selector: '[treeNodeDrop]'
                },] },
    ];
    /** @nocollapse */
    TreeNodeDrop.ctorParameters = [
        { type: core_1.ElementRef, },
        { type: core_1.Renderer, },
        { type: tree_node_drag_model_1.TreeNodeDrag, },
    ];
    TreeNodeDrop.propDecorators = {
        'treeNodeDrop': [{ type: core_1.Input, args: ['treeNodeDrop',] },],
        'onDragOver': [{ type: core_1.HostListener, args: ['dragover', ['$event'],] },],
        'onDragLeave': [{ type: core_1.HostListener, args: ['dragleave', ['$event'],] },],
        'onDrop': [{ type: core_1.HostListener, args: ['drop', ['$event'],] },],
    };
    return TreeNodeDrop;
}());
exports.TreeNodeDrop = TreeNodeDrop;
//# sourceMappingURL=data:application/json;base64,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