"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var core_1 = require('@angular/core');
var tree_node_model_1 = require('../models/tree-node.model');
var TreeNodeComponent = (function () {
    function TreeNodeComponent(elementRef) {
        this.elementRef = elementRef;
    }
    // TODO: move to draggable directive
    TreeNodeComponent.prototype.onDragStart = function () {
        var _this = this;
        setTimeout(function () { return _this.node.treeModel.setDragNode({ node: _this.node.parent, index: _this.nodeIndex }); }, 30);
    };
    TreeNodeComponent.prototype.onDragEnd = function () {
        this.node.treeModel.setDragNode(null);
    };
    TreeNodeComponent.prototype.onDragOver = function ($event) {
        $event.preventDefault();
        this.node.treeModel.setDropLocation({ component: this, node: this.node, index: 0 });
    };
    TreeNodeComponent.prototype.onDrop = function ($event) {
        $event.preventDefault();
        this.node.mouseAction('drop', $event, { node: this.node, index: 0 });
    };
    TreeNodeComponent.prototype.onDragLeave = function (nodeContentWrapper, $event) {
        if (!this.node.treeModel.isDraggingOver(this))
            return;
        var rect = nodeContentWrapper.getBoundingClientRect();
        // If outside the element
        if ($event.clientX < rect.left || $event.clientX > rect.right ||
            $event.clientY < rect.top || $event.clientY > rect.bottom) {
            this.node.treeModel.setDropLocation(null);
        }
    };
    TreeNodeComponent.prototype.ngAfterViewInit = function () {
        this.node.elementRef = this.elementRef;
    };
    __decorate([
        core_1.Input(), 
        __metadata('design:type', tree_node_model_1.TreeNode)
    ], TreeNodeComponent.prototype, "node", void 0);
    __decorate([
        core_1.Input(), 
        __metadata('design:type', Number)
    ], TreeNodeComponent.prototype, "nodeIndex", void 0);
    __decorate([
        core_1.Input(), 
        __metadata('design:type', core_1.TemplateRef)
    ], TreeNodeComponent.prototype, "treeNodeContentTemplate", void 0);
    __decorate([
        core_1.Input(), 
        __metadata('design:type', core_1.TemplateRef)
    ], TreeNodeComponent.prototype, "loadingTemplate", void 0);
    TreeNodeComponent = __decorate([
        core_1.Component({
            selector: 'TreeNode',
            encapsulation: core_1.ViewEncapsulation.None,
            styles: [
                '.tree-children { padding-left: 20px }',
                ".node-content-wrapper {\n      display: inline-block;\n      padding: 2px 5px;\n      border-radius: 2px;\n      transition: background-color .15s,box-shadow .15s;\n    }",
                '.node-wrapper {display: flex; align-items: flex-start;}',
                '.tree-node-active > .node-wrapper > .node-content-wrapper { background: #beebff }',
                '.tree-node-active.tree-node-focused > .node-wrapper > .node-content-wrapper { background: #beebff }',
                '.tree-node-focused > .node-wrapper > .node-content-wrapper { background: #e7f4f9 }',
                '.node-content-wrapper:hover { background: #f7fbff }',
                '.tree-node-active > .node-wrapper > .node-content-wrapper, .tree-node-focused > .node-content-wrapper, .node-content-wrapper:hover { box-shadow: inset 0 0 1px #999; }',
                '.node-content-wrapper.is-dragging-over { background: #ddffee; box-shadow: inset 0 0 1px #999; }',
                '.tree-node-expanded > .node-wrapper > .toggle-children-wrapper > .toggle-children { transform: rotate(90deg) }',
                '.tree-node-collapsed > .node-wrapper > .toggle-children-wrapper > .toggle-children { transform: rotate(0); }',
                ".toggle-children-wrapper {\n      padding: 2px 3px 5px 1px;\n    }",
                ".toggle-children {\n        background-image: url('data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAASCAYAAABSO15qAAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAABAhpVFh0WE1MOmNvbS5hZG9iZS54bXAAAAAAADw/eHBhY2tldCBiZWdpbj0i77u/IiBpZD0iVzVNME1wQ2VoaUh6cmVTek5UY3prYzlkIj8+IDx4OnhtcG1ldGEgeG1sbnM6eD0iYWRvYmU6bnM6bWV0YS8iIHg6eG1wdGs9IkFkb2JlIFhNUCBDb3JlIDUuNi1jMDY3IDc5LjE1Nzc0NywgMjAxNS8wMy8zMC0yMzo0MDo0MiAgICAgICAgIj4gPHJkZjpSREYgeG1sbnM6cmRmPSJodHRwOi8vd3d3LnczLm9yZy8xOTk5LzAyLzIyLXJkZi1zeW50YXgtbnMjIj4gPHJkZjpEZXNjcmlwdGlvbiByZGY6YWJvdXQ9IiIgeG1sbnM6eG1wTU09Imh0dHA6Ly9ucy5hZG9iZS5jb20veGFwLzEuMC9tbS8iIHhtbG5zOnN0UmVmPSJodHRwOi8vbnMuYWRvYmUuY29tL3hhcC8xLjAvc1R5cGUvUmVzb3VyY2VSZWYjIiB4bWxuczp4bXA9Imh0dHA6Ly9ucy5hZG9iZS5jb20veGFwLzEuMC8iIHhtbG5zOmRjPSJodHRwOi8vcHVybC5vcmcvZGMvZWxlbWVudHMvMS4xLyIgeG1wTU06T3JpZ2luYWxEb2N1bWVudElEPSJ1dWlkOjY1RTYzOTA2ODZDRjExREJBNkUyRDg4N0NFQUNCNDA3IiB4bXBNTTpEb2N1bWVudElEPSJ4bXAuZGlkOkYzRkRFQjcxODUzNTExRTU4RTQwRkQwODFEOUZEMEE3IiB4bXBNTTpJbnN0YW5jZUlEPSJ4bXAuaWlkOkYzRkRFQjcwODUzNTExRTU4RTQwRkQwODFEOUZEMEE3IiB4bXA6Q3JlYXRvclRvb2w9IkFkb2JlIFBob3Rvc2hvcCBDQyAyMDE1IChNYWNpbnRvc2gpIj4gPHhtcE1NOkRlcml2ZWRGcm9tIHN0UmVmOmluc3RhbmNlSUQ9InhtcC5paWQ6MTk5NzA1OGEtZDI3OC00NDZkLWE4ODgtNGM4MGQ4YWI1NzNmIiBzdFJlZjpkb2N1bWVudElEPSJhZG9iZTpkb2NpZDpwaG90b3Nob3A6YzRkZmQxMGMtY2NlNS0xMTc4LWE5OGQtY2NkZmM5ODk5YWYwIi8+IDxkYzp0aXRsZT4gPHJkZjpBbHQ+IDxyZGY6bGkgeG1sOmxhbmc9IngtZGVmYXVsdCI+Z2x5cGhpY29uczwvcmRmOmxpPiA8L3JkZjpBbHQ+IDwvZGM6dGl0bGU+IDwvcmRmOkRlc2NyaXB0aW9uPiA8L3JkZjpSREY+IDwveDp4bXBtZXRhPiA8P3hwYWNrZXQgZW5kPSJyIj8+5iogFwAAAGhJREFUeNpiYGBgKABigf///zOQg0EARH4A4gZyDIIZ8B/JoAJKDIDhB0CcQIkBRBtEyABkgxwoMQCGD6AbRKoBGAYxQgXIBRuZGKgAKPIC3QLxArnRSHZCIjspk52ZKMrOFBUoAAEGAKnq593MQAZtAAAAAElFTkSuQmCC');\n        height: 8px;\n        width: 9px;\n        background-size: contain;\n        display: inline-block;\n        position: relative;\n        background-repeat: no-repeat;\n        background-position: center;\n    }",
                ".toggle-children-placeholder {\n        display: inline-block;\n        height: 10px;\n        width: 10px;\n        position: relative;\n        top: 1px;\n        padding-right: 5px;\n    }"
            ],
            template: "\n    <div\n      *ngIf=\"!node.isHidden\"\n      class=\"tree-node tree-node-level-{{ node.level }}\"\n      [class.tree-node-expanded]=\"node.isExpanded && node.hasChildren\"\n      [class.tree-node-collapsed]=\"node.isCollapsed && node.hasChildren\"\n      [class.tree-node-leaf]=\"node.isLeaf\"\n      [class.tree-node-active]=\"node.isActive\"\n      [class.tree-node-focused]=\"node.isFocused\">\n\n      <TreeNodeDropSlot\n        *ngIf=\"nodeIndex === 0\"\n        [dropIndex]=\"nodeIndex\"\n        [node]=\"node.parent\"\n        ></TreeNodeDropSlot>\n\n        <div class=\"node-wrapper\">\n          <span\n            *ngIf=\"node.hasChildren\"\n            class=\"toggle-children-wrapper\"\n            (click)=\"node.mouseAction('expanderClick', $event)\">\n\n            <span class=\"toggle-children\"></span>\n          </span>\n          <span\n            *ngIf=\"!node.hasChildren\"\n            class=\"toggle-children-placeholder\">\n          </span>\n          <div class=\"node-content-wrapper\"\n            #nodeContentWrapper\n            [class.is-dragging-over]=\"node.treeModel.isDraggingOver(this)\"\n            (click)=\"node.mouseAction('click', $event)\"\n            (dblclick)=\"node.mouseAction('dblClick', $event)\"\n            (contextmenu)=\"node.mouseAction('contextMenu', $event)\"\n            [draggable]=\"node.allowDrag()\"\n            (dragstart)=\"onDragStart($event)\"\n            (drop)=\"onDrop($event)\"\n            (dragend)=\"onDragEnd()\"\n            (dragover)=\"onDragOver($event)\"\n            (dragleave)=\"onDragLeave(nodeContentWrapper, $event)\"\n            >\n\n            <TreeNodeContent [node]=\"node\" [treeNodeContentTemplate]=\"treeNodeContentTemplate\"></TreeNodeContent>\n          </div>\n        </div>\n\n      <div class=\"tree-children\" *ngIf=\"node.isExpanded\">\n        <div *ngIf=\"node.children\">\n          <TreeNode\n            *ngFor=\"let node of node.children; let i = index\"\n            [node]=\"node\"\n            [nodeIndex]=\"i\"\n            [treeNodeContentTemplate]=\"treeNodeContentTemplate\"\n            [loadingTemplate]=\"loadingTemplate\">\n          </TreeNode>\n        </div>\n        <LoadingComponent\n          class=\"tree-node-loading\"\n          *ngIf=\"!node.children\"\n          [loadingTemplate]=\"loadingTemplate\"\n        ></LoadingComponent>\n      </div>\n      <TreeNodeDropSlot\n        [dropIndex]=\"nodeIndex + 1\"\n        [node]=\"node.parent\"\n        ></TreeNodeDropSlot>\n    </div>\n  "
        }), 
        __metadata('design:paramtypes', [core_1.ElementRef])
    ], TreeNodeComponent);
    return TreeNodeComponent;
}());
exports.TreeNodeComponent = TreeNodeComponent;
//# sourceMappingURL=data:application/json;base64,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