"use strict";
var keys_1 = require('../constants/keys');
var deprecated_1 = require('../deprecated');
var lodash_1 = require('lodash');
exports.TREE_ACTIONS = {
    TOGGLE_SELECTED: function (tree, node, $event) { return node.toggleActivated(); },
    TOGGLE_SELECTED_MULTI: function (tree, node, $event) { return node.toggleActivated(true); },
    SELECT: function (tree, node, $event) { return node.setIsActive(true); },
    DESELECT: function (tree, node, $event) { return node.setIsActive(false); },
    FOCUS: function (tree, node, $event) { return node.focus(); },
    TOGGLE_EXPANDED: function (tree, node, $event) { return node.toggleExpanded(); },
    EXPAND: function (tree, node, $event) { return node.expand(); },
    COLLAPSE: function (tree, node, $event) { return node.collapse(); },
    DRILL_DOWN: function (tree, node, $event) { return tree.focusDrillDown(); },
    DRILL_UP: function (tree, node, $event) { return tree.focusDrillUp(); },
    NEXT_NODE: function (tree, node, $event) { return tree.focusNextNode(); },
    PREVIOUS_NODE: function (tree, node, $event) { return tree.focusPreviousNode(); },
    MOVE_NODE: function (tree, node, $event, to) {
        tree.moveNode({ from: tree.getDragNode(), to: to });
    }
};
var defaultActionMapping = {
    mouse: {
        click: exports.TREE_ACTIONS.TOGGLE_SELECTED,
        dblClick: null,
        contextMenu: null,
        expanderClick: exports.TREE_ACTIONS.TOGGLE_EXPANDED,
        drop: exports.TREE_ACTIONS.MOVE_NODE
    },
    keys: (_a = {},
        _a[keys_1.KEYS.RIGHT] = exports.TREE_ACTIONS.DRILL_DOWN,
        _a[keys_1.KEYS.LEFT] = exports.TREE_ACTIONS.DRILL_UP,
        _a[keys_1.KEYS.DOWN] = exports.TREE_ACTIONS.NEXT_NODE,
        _a[keys_1.KEYS.UP] = exports.TREE_ACTIONS.PREVIOUS_NODE,
        _a[keys_1.KEYS.SPACE] = exports.TREE_ACTIONS.TOGGLE_SELECTED,
        _a[keys_1.KEYS.ENTER] = exports.TREE_ACTIONS.TOGGLE_SELECTED,
        _a
    )
};
var TreeOptions = (function () {
    function TreeOptions(options) {
        if (options === void 0) { options = {}; }
        this.options = options;
        this.actionMapping = lodash_1.defaultsDeep(this.options.actionMapping, defaultActionMapping);
        if (options.hasCustomContextMenu) {
            deprecated_1.deprecated('hasCustomContextMenu', 'actionMapping: mouse: contextMenu');
        }
        if (options.context) {
            deprecated_1.deprecated('context', 'values directly in a template in the content of the <Tree> component like this: <Tree><template #treeNodeTemplate let-node>{{ outsideValue }}</template></Tree>.  If you don\'t have time to update your code and don\'t need AoT compilation, use DeprecatedTreeModule');
        }
        if (options.treeNodeTemplate) {
            deprecated_1.deprecated('treeNodeTemplate', 'a template in the content of the <Tree> component like this: <Tree><template #treeNodeTemplate let-node>...</template></Tree>.  If you don\'t have time to update your code and don\'t need AoT compilation, use DeprecatedTreeModule');
        }
        if (options.loadingComponent) {
            deprecated_1.deprecated('loadingComponent', 'a template in the content of the <Tree> component like this: <Tree><template #loadingTemplate>...</template></Tree>.  If you don\'t have time to update your code and don\'t need AoT compilation, use DeprecatedTreeModule');
        }
        if (lodash_1.get(options, 'mouse.shift')) {
            deprecated_1.deprecated('mouse.shift', '$event.shiftKey in click action instead');
        }
        if (lodash_1.get(options, 'mouse.ctrl')) {
            deprecated_1.deprecated('mouse.ctrl', '$event.ctrlKey in click action instead');
        }
        if (lodash_1.get(options, 'mouse.alt')) {
            deprecated_1.deprecated('mouse.alt', '$event.altKey in click action instead');
        }
    }
    Object.defineProperty(TreeOptions.prototype, "childrenField", {
        get: function () { return this.options.childrenField || 'children'; },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(TreeOptions.prototype, "displayField", {
        get: function () { return this.options.displayField || 'name'; },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(TreeOptions.prototype, "idField", {
        get: function () { return this.options.idField || 'id'; },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(TreeOptions.prototype, "isExpandedField", {
        get: function () { return this.options.isExpandedField || 'isExpanded'; },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(TreeOptions.prototype, "isHiddenField", {
        get: function () { return this.options.isHiddenField || 'isHidden'; },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(TreeOptions.prototype, "treeNodeTemplate", {
        get: function () { return this.options.treeNodeTemplate; },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(TreeOptions.prototype, "loadingComponent", {
        get: function () { return this.options.loadingComponent; },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(TreeOptions.prototype, "getChildren", {
        get: function () { return this.options.getChildren; },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(TreeOptions.prototype, "hasCustomContextMenu", {
        get: function () { return this.options.hasCustomContextMenu; },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(TreeOptions.prototype, "context", {
        get: function () { return this.options.context; },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(TreeOptions.prototype, "allowDrag", {
        get: function () { return this.options.allowDrag; },
        enumerable: true,
        configurable: true
    });
    return TreeOptions;
}());
exports.TreeOptions = TreeOptions;
var _a;
//# sourceMappingURL=data:application/json;base64,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