import { TreeNode } from './tree-node.model';
import { TreeOptions } from './tree-options.model';
import { ITreeModel } from '../defs/api';
export declare class TreeModel implements ITreeModel {
    roots: TreeNode[];
    options: TreeOptions;
    nodes: any[];
    expandedNodeIds: {
        [id: string]: boolean;
    };
    expandedNodes: TreeNode[];
    activeNodeIds: {
        [id: string]: boolean;
    };
    activeNodes: TreeNode[];
    _focusedNode: TreeNode;
    focusedNodeId: string;
    static focusedTree: any;
    private events;
    virtualRoot: TreeNode;
    firstUpdate: boolean;
    eventNames: string[];
    setData({nodes, options, events}: {
        nodes: any;
        options: any;
        events: any;
    }): void;
    update(): void;
    _calculateExpandedNodes(startNode?: any): void;
    fireEvent(event: any): void;
    focusedNode: TreeNode;
    getFocusedNode(): TreeNode;
    setFocusedNode(node: any): void;
    getActiveNode(): TreeNode;
    getActiveNodes(): TreeNode[];
    getTreeNode(node: any, parent: TreeNode): TreeNode;
    getVisibleRoots(): TreeNode[];
    getFirstRoot(skipHidden?: boolean): TreeNode;
    getLastRoot(skipHidden?: boolean): TreeNode;
    readonly isFocused: boolean;
    isNodeFocused(node: any): boolean;
    setFocus(value: any): void;
    isEmptyTree(): boolean;
    private _treeNodeContentComponent;
    readonly treeNodeContentComponent: any;
    private _loadingComponent;
    readonly loadingComponent: any;
    _initTreeNodeContentComponent(): void;
    _initLoadingComponent(): void;
    _loadState(): void;
    getNodeByPath(path: any, startNode?: any): TreeNode;
    getNodeById(id: any): any;
    getNodeBy(predicate: any, startNode?: any): any;
    _createAdHocComponent(templateStr: any): any;
    focusNextNode(): void;
    focusPreviousNode(): void;
    focusDrillDown(): void;
    focusDrillUp(): void;
    isActive(node: any): boolean;
    setActiveNode(node: any, value: any, multi?: boolean): void;
    _setActiveNodeSingle(node: any, value: any): void;
    _setActiveNodeMulti(node: any, value: any): void;
    isExpanded(node: any): boolean;
    setExpandedNode(node: any, value: any): void;
    performKeyAction(node: any, $event: any): boolean;
    filterNodes(filter: any, autoShow?: boolean): void;
    clearFilter(): void;
    private _canMoveNode(node, fromIndex, to);
    moveNode(node: any, to: any): void;
}
