"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var core_1 = require('@angular/core');
var forms_1 = require('@angular/forms');
var UI_SWITCH_CONTROL_VALUE_ACCESSOR = {
    provide: forms_1.NG_VALUE_ACCESSOR,
    useExisting: core_1.forwardRef(function () { return UiSwitchComponent; }),
    multi: true
};
var UiSwitchComponent = (function () {
    function UiSwitchComponent() {
        this.onTouchedCallback = function (v) {
        };
        this.onChangeCallback = function (v) {
        };
        this.size = 'medium';
        this.change = new core_1.EventEmitter();
        this.color = 'rgb(100, 189, 99)';
        this.defaultBgColor = '#fff';
        this.defaultBoColor = '#dfdfdf';
    }
    Object.defineProperty(UiSwitchComponent.prototype, "checked", {
        get: function () {
            return this._checked;
        },
        set: function (v) {
            this._checked = v !== false;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(UiSwitchComponent.prototype, "disabled", {
        get: function () {
            return this._disabled;
        },
        set: function (v) {
            this._disabled = v !== false;
        },
        enumerable: true,
        configurable: true
    });
    ;
    UiSwitchComponent.prototype.onToggle = function () {
        if (this.disabled)
            return;
        this.checked = !this.checked;
        this.change.emit(this.checked);
        this.onChangeCallback(this.checked);
        this.onTouchedCallback(this.checked);
    };
    UiSwitchComponent.prototype.writeValue = function (obj) {
        if (obj !== this.checked) {
            this.checked = !!obj;
        }
    };
    UiSwitchComponent.prototype.registerOnChange = function (fn) {
        this.onChangeCallback = fn;
    };
    UiSwitchComponent.prototype.registerOnTouched = function (fn) {
        this.onTouchedCallback = fn;
    };
    __decorate([
        core_1.Input(), 
        __metadata('design:type', Boolean), 
        __metadata('design:paramtypes', [Boolean])
    ], UiSwitchComponent.prototype, "checked", null);
    __decorate([
        core_1.Input(), 
        __metadata('design:type', Boolean), 
        __metadata('design:paramtypes', [Boolean])
    ], UiSwitchComponent.prototype, "disabled", null);
    __decorate([
        core_1.Input(), 
        __metadata('design:type', String)
    ], UiSwitchComponent.prototype, "size", void 0);
    __decorate([
        core_1.Output(), 
        __metadata('design:type', Object)
    ], UiSwitchComponent.prototype, "change", void 0);
    __decorate([
        core_1.Input(), 
        __metadata('design:type', String)
    ], UiSwitchComponent.prototype, "color", void 0);
    __decorate([
        core_1.HostListener('click'), 
        __metadata('design:type', Function), 
        __metadata('design:paramtypes', []), 
        __metadata('design:returntype', void 0)
    ], UiSwitchComponent.prototype, "onToggle", null);
    UiSwitchComponent = __decorate([
        core_1.Component({
            selector: 'ui-switch',
            template: "\n        <span class=\"switch\" \n        [class.checked]=\"checked\" \n        [class.disabled]=\"disabled\"\n        [class.switch-large]=\"size === 'large'\"\n        [class.switch-medium]=\"size === 'medium'\"\n        [class.switch-small]=\"size === 'small'\"\n        [style.background-color]=\"checked ? color : defaultBgColor\"\n        [style.border-color]=\"checked ? color : defaultBoColor\"\n        >\n            <small></small>\n        </span>\n    ",
            styles: ["\n        .switch {\n            background: #fff;\n            border: 1px solid #dfdfdf;\n            position: relative;\n            display: inline-block;\n            box-sizing: content-box;\n            overflow: visible;\n            padding: 0;\n            margin: 0;            \n            cursor: pointer;\n            box-shadow: rgb(223, 223, 223) 0 0 0 0 inset;\n            transition: 0.3s ease-out all;\n            -webkit-transition: 0.3s ease-out all;\n        }        \n                \n        small {\n            background: #fff;\n            border-radius: 100%;\n            box-shadow: 0 1px 3px rgba(0, 0, 0, 0.4);          \n            position: absolute;\n            top: 0;\n            left: 0;\n            transition: 0.3s ease-out all;\n            -webkit-transition: 0.3s ease-out all;\n        }\n        \n        .switch-large {\n            width: 66px;\n            height: 40px;\n            border-radius: 40px;\n        }\n\n        .switch-large small {\n            width: 40px;\n            height: 40px;\n        }\n        \n        .switch-medium {\n            width: 50px;\n            height: 30px;\n            border-radius: 30px;\n        }\n        \n        .switch-medium small {\n            width: 30px;\n            height: 30px;\n        }\n        \n        .switch-small {\n            width: 33px;\n            height: 20px;\n            border-radius: 20px;\n        }\n        \n        .switch-small small {\n            width: 20px;\n            height: 20px;\n        }\n        \n        .checked {\n            background: rgb(100, 189, 99);\n            border-color: rgb(100, 189, 99);\n        }\n        \n        .switch-large.checked small {\n            left: 26px;\n        }\n        \n        .switch-medium.checked small {\n            left: 20px;\n        }\n        \n        .switch-small.checked small {\n            left: 13px;\n        }\n        \n        .disabled {\n            opacity: .50;\n            cursor: not-allowed;\n        }\n    "],
            providers: [UI_SWITCH_CONTROL_VALUE_ACCESSOR]
        }), 
        __metadata('design:paramtypes', [])
    ], UiSwitchComponent);
    return UiSwitchComponent;
}());
exports.UiSwitchComponent = UiSwitchComponent;
//# sourceMappingURL=ui-switch.component.js.map