import { ComponentRef, PlatformRef, ApplicationRef } from 'angular2/core';
export declare type configRefs = {
    componentRef: ComponentRef;
    applicationRef: ApplicationRef;
};
export interface BootloaderConfig {
    template?: string;
    document?: string;
    platformProviders?: Array<any>;
    providers?: Array<any>;
    componentProviders?: Array<any>;
    component?: any;
    directives?: Array<any>;
    preboot?: boolean | any;
    precache?: boolean;
    primeCache?: boolean;
    async?: boolean;
    prime?: boolean;
    beautify?: boolean;
    maxZoneTurns?: number;
    bootloader?: Bootloader | any;
    ngOnInit?: (config?: configRefs, document?: any) => any | Promise<any>;
    ngOnStable?: (config?: configRefs, document?: any) => any | Promise<any>;
    ngOnRendered?: (rendered?: string) => string | any | Promise<any>;
    ngDoCheck?: (config: configRefs) => boolean;
}
export declare class Bootloader {
    private _config;
    platformRef: any;
    applicationRef: any;
    constructor(config: BootloaderConfig);
    static create(config: any): Bootloader;
    static applicationRefToString(applicationRefs: any): string;
    static parseFragment(document: any): Object;
    static parseDocument(document: any): Object;
    static serializeDocument(document: any): string;
    document(document?: any): any;
    platform(providers?: any): PlatformRef;
    application(document?: any, providers?: any): any;
    bootstrap(Component?: any | Array<any>): Promise<any>;
    serialize(Component?: any | Array<any>): Promise<any>;
    serializeApplication(Component?: any | Array<any>, componentProviders?: Array<any>): Promise<any>;
    _bootstrapAll(Components?: Array<any>, componentProviders?: Array<any>): Promise<Array<any>>;
    _applicationAll(Components?: Array<any>, providers?: any): Promise<Array<any>>;
    dispose(): void;
}
export declare function bootloader(config?: BootloaderConfig): Bootloader;
