"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
var http_1 = require('angular2/http');
var utils = require('angular2/src/http/http_utils');
var lang_1 = require('angular2/src/facade/lang');
var core_1 = require('angular2/core');
var Observable_1 = require('rxjs/Observable');
require('rxjs/add/operator/map');
var http = require('http');
var https = require('https');
var url = require('url');
var common_1 = require('../../common');
var NodeConnection = (function () {
    function NodeConnection(req, baseResponseOptions, ngZome, originUrl, baseUrl) {
        if (originUrl === void 0) { originUrl = ''; }
        this.request = req;
        baseUrl = baseUrl || '/';
        if (originUrl === null) {
            throw new Error('ERROR: Please move ORIGIN_URL to platformProviders');
        }
        var _reqInfo = url.parse(url.resolve(url.resolve(originUrl, baseUrl), req.url));
        _reqInfo.method = http_1.RequestMethod[req.method].toUpperCase();
        if (lang_1.isPresent(req.headers)) {
            _reqInfo.headers = {};
            req.headers.forEach(function (values, name) { return _reqInfo.headers[name] = values.join(','); });
        }
        this.response = new Observable_1.Observable(function (responseObserver) {
            var nodeReq;
            ngZome.run(function () {
                // http or https
                var xhrHttp = http;
                if (_reqInfo.protocol === 'https:') {
                    xhrHttp = https;
                }
                nodeReq = xhrHttp.request(_reqInfo, function (res) {
                    var body = '';
                    res.on('data', function (chunk) { return body += chunk; });
                    var status = res.statusCode;
                    var headers = new http_1.Headers(res.headers);
                    var url = res.url;
                    res.on('end', function () {
                        var responseOptions = new http_1.ResponseOptions({ body: body, status: status, headers: headers, url: url });
                        var response = new http_1.Response(responseOptions);
                        if (utils.isSuccess(status)) {
                            ngZome.run(function () {
                                responseObserver.next(response);
                            });
                            ngZome.run(function () {
                                responseObserver.complete();
                            });
                            return;
                        }
                        ngZome.run(function () {
                            responseObserver.error(response);
                        });
                    });
                });
            });
            var onError = function (err) {
                var responseOptions = new http_1.ResponseOptions({ body: err, type: http_1.ResponseType.Error });
                if (lang_1.isPresent(baseResponseOptions)) {
                    responseOptions = baseResponseOptions.merge(responseOptions);
                }
                ngZome.run(function () {
                    responseObserver.error(new http_1.Response(responseOptions));
                });
            };
            nodeReq.on('error', onError);
            nodeReq.write(req.text());
            nodeReq.end();
            return function () {
                nodeReq.removeListener('error', onError);
                nodeReq.abort();
            };
        });
    }
    NodeConnection = __decorate([
        __param(3, core_1.Inject(common_1.ORIGIN_URL)),
        __param(4, core_1.Optional()),
        __param(4, core_1.Inject(common_1.BASE_URL)), 
        __metadata('design:paramtypes', [http_1.Request, http_1.ResponseOptions, core_1.NgZone, String, String])
    ], NodeConnection);
    return NodeConnection;
}());
exports.NodeConnection = NodeConnection;
var NodeBackend = (function () {
    function NodeBackend(_baseResponseOptions, _ngZone, _baseUrl, _originUrl) {
        this._baseResponseOptions = _baseResponseOptions;
        this._ngZone = _ngZone;
        this._baseUrl = _baseUrl;
        this._originUrl = _originUrl;
    }
    NodeBackend.prototype.createConnection = function (request) {
        return new NodeConnection(request, this._baseResponseOptions, this._ngZone, this._baseUrl, this._originUrl);
    };
    NodeBackend = __decorate([
        core_1.Injectable(),
        __param(2, core_1.Inject(common_1.BASE_URL)),
        __param(3, core_1.Inject(common_1.ORIGIN_URL)), 
        __metadata('design:paramtypes', [http_1.ResponseOptions, core_1.NgZone, String, String])
    ], NodeBackend);
    return NodeBackend;
}());
exports.NodeBackend = NodeBackend;
//# sourceMappingURL=node_http.js.map