"use strict";
// Facade
var lang_1 = require('angular2/src/facade/lang');
// Compiler
var compiler_1 = require('angular2/compiler');
// Animate
var browser_details_1 = require('angular2/src/animate/browser_details');
var animation_builder_1 = require('angular2/src/animate/animation_builder');
// Core
var testability_1 = require('angular2/src/core/testability/testability');
var reflection_capabilities_1 = require('angular2/src/core/reflection/reflection_capabilities');
var directive_resolver_1 = require('angular2/src/compiler/directive_resolver');
var core_1 = require('angular2/core');
// Common
var common_1 = require('angular2/common');
// Platform
var parse5_adapter_1 = require('angular2/src/platform/server/parse5_adapter');
parse5_adapter_1.Parse5DomAdapter.makeCurrent(); // ensure Parse5DomAdapter is used
// Platform.Dom
var dom_adapter_1 = require('angular2/src/platform/dom/dom_adapter');
var event_manager_1 = require('angular2/src/platform/dom/events/event_manager');
var dom_events_1 = require('angular2/src/platform/dom/events/dom_events');
var key_events_1 = require('angular2/src/platform/dom/events/key_events');
var hammer_gestures_1 = require('angular2/src/platform/dom/events/hammer_gestures');
var shared_styles_host_1 = require('angular2/src/platform/dom/shared_styles_host');
var hammer_gestures_2 = require('angular2/src/platform/dom/events/hammer_gestures');
var common_dom_1 = require('angular2/platform/common_dom');
var dom_tokens_1 = require('angular2/src/platform/dom/dom_tokens');
var dom_renderer_1 = require('angular2/src/platform/dom/dom_renderer');
var api_1 = require('angular2/src/core/render/api');
var template_parser_1 = require('angular2/src/compiler/template_parser');
var node_dom_renderer_1 = require('./dom/node_dom_renderer');
var node_xhr_impl_1 = require('./node_xhr_impl');
var node_shared_styles_host_1 = require('./node_shared_styles_host');
var node_template_parser_1 = require('./node_template_parser');
var directives_1 = require('../directives');
function initNodeAdapter() {
    parse5_adapter_1.Parse5DomAdapter.makeCurrent();
}
exports.initNodeAdapter = initNodeAdapter;
exports.NODE_APP_PLATFORM_MARKER = new core_1.OpaqueToken('NodeAppPlatformMarker');
exports.NODE_APP_PLATFORM = lang_1.CONST_EXPR(core_1.PLATFORM_COMMON_PROVIDERS.concat([
    new core_1.Provider(exports.NODE_APP_PLATFORM_MARKER, { useValue: true }),
    new core_1.Provider(core_1.PLATFORM_INITIALIZER, { useValue: initNodeAdapter, multi: true }),
]));
function _exceptionHandler() {
    return new core_1.ExceptionHandler(dom_adapter_1.DOM, false);
}
function _document() {
    return dom_adapter_1.DOM.createHtmlDocument();
}
exports.NODE_APP_COMMON_PROVIDERS = lang_1.CONST_EXPR(core_1.APPLICATION_COMMON_PROVIDERS.concat(common_1.FORM_PROVIDERS, [
    new core_1.Provider(core_1.PLATFORM_PIPES, { useValue: common_1.COMMON_PIPES, multi: true }),
    new core_1.Provider(core_1.PLATFORM_DIRECTIVES, { useValue: common_1.COMMON_DIRECTIVES, multi: true }),
    new core_1.Provider(core_1.ExceptionHandler, { useFactory: _exceptionHandler, deps: [] })
], directives_1.NODE_PLATFORM_DIRECTIVES, [
    new core_1.Provider(dom_tokens_1.DOCUMENT, { useFactory: function () { return _document; } }),
    new core_1.Provider(event_manager_1.EVENT_MANAGER_PLUGINS, { useClass: dom_events_1.DomEventsPlugin, multi: true }),
    new core_1.Provider(event_manager_1.EVENT_MANAGER_PLUGINS, { useClass: key_events_1.KeyEventsPlugin, multi: true }),
    new core_1.Provider(event_manager_1.EVENT_MANAGER_PLUGINS, { useClass: hammer_gestures_1.HammerGesturesPlugin, multi: true }),
    new core_1.Provider(hammer_gestures_2.HAMMER_GESTURE_CONFIG, { useClass: hammer_gestures_2.HammerGestureConfig }),
    new core_1.Provider(dom_renderer_1.DomRootRenderer, { useClass: node_dom_renderer_1.NodeDomRootRenderer_ }),
    new core_1.Provider(api_1.RootRenderer, { useExisting: dom_renderer_1.DomRootRenderer }),
    new core_1.Provider(shared_styles_host_1.SharedStylesHost, { useExisting: node_shared_styles_host_1.NodeSharedStylesHost }),
    new core_1.Provider(shared_styles_host_1.DomSharedStylesHost, { useExisting: node_shared_styles_host_1.NodeSharedStylesHost }),
    node_shared_styles_host_1.NodeSharedStylesHost,
    testability_1.Testability,
    browser_details_1.BrowserDetails,
    animation_builder_1.AnimationBuilder,
    event_manager_1.EventManager
], common_dom_1.ELEMENT_PROBE_PROVIDERS));
/**
 * An array of providers that should be passed into `application()` when bootstrapping a component.
 */
exports.NODE_APP_PROVIDERS = lang_1.CONST_EXPR(exports.NODE_APP_COMMON_PROVIDERS.concat(compiler_1.COMPILER_PROVIDERS, [
    new core_1.Provider(template_parser_1.TemplateParser, { useClass: node_template_parser_1.NodeTemplateParser }),
    new core_1.Provider(compiler_1.XHR, { useClass: node_xhr_impl_1.NodeXHRImpl }),
]));
/**
 *
 */
function bootstrap(appComponentType, customAppProviders, customComponentProviders) {
    if (customAppProviders === void 0) { customAppProviders = null; }
    if (customComponentProviders === void 0) { customComponentProviders = null; }
    core_1.reflector.reflectionCapabilities = new reflection_capabilities_1.ReflectionCapabilities();
    var appProviders = exports.NODE_APP_PROVIDERS.concat([
        new core_1.Provider(dom_tokens_1.DOCUMENT, {
            useFactory: function (directiveResolver, sharedStylesHost) {
                // TODO(gdi2290): determine a better for document on the server
                var selector = directiveResolver.resolve(appComponentType);
                var serverDocument = dom_adapter_1.DOM.createHtmlDocument();
                var el = dom_adapter_1.DOM.createElement(selector);
                dom_adapter_1.DOM.appendChild(serverDocument.body, el);
                sharedStylesHost.addHost(serverDocument.head);
                return serverDocument;
            },
            deps: [directive_resolver_1.DirectiveResolver, node_shared_styles_host_1.NodeSharedStylesHost]
        })
    ], (lang_1.isPresent(customAppProviders) ? customAppProviders : []));
    var componentProviders = (lang_1.isPresent(customComponentProviders) ? customComponentProviders : []).slice();
    var platform = core_1.createPlatform(core_1.ReflectiveInjector.resolveAndCreate(exports.NODE_APP_PLATFORM));
    return core_1.coreLoadAndBootstrap(platform.injector, appComponentType);
}
exports.bootstrap = bootstrap;
function buildReflector() {
    core_1.reflector.reflectionCapabilities = new reflection_capabilities_1.ReflectionCapabilities();
}
exports.buildReflector = buildReflector;
function buildNodeProviders(providers) {
    return exports.NODE_APP_PLATFORM.concat((lang_1.isPresent(providers) ? providers : []));
}
exports.buildNodeProviders = buildNodeProviders;
function buildNodeAppProviders(document, providers) {
    return exports.NODE_APP_PROVIDERS.concat([
        (lang_1.isPresent(document) && document) ? [
            new core_1.Provider(dom_tokens_1.DOCUMENT, {
                useFactory: function (sharedStylesHost) {
                    sharedStylesHost.addHost(document.head);
                    return document;
                },
                deps: [node_shared_styles_host_1.NodeSharedStylesHost]
            })
        ] : []
    ], (lang_1.isPresent(providers) && providers) ? providers : []);
}
exports.buildNodeAppProviders = buildNodeAppProviders;
function buildNodePlatformProviders(appComponentType, providers) {
    return exports.NODE_APP_PLATFORM.concat((lang_1.isPresent(providers) ? providers : []));
}
exports.buildNodePlatformProviders = buildNodePlatformProviders;
//# sourceMappingURL=node.js.map