"use strict";
var node_1 = require('./platform/node');
var common_dom_1 = require('angular2/platform/common_dom');
var document_1 = require('./platform/document');
var stringify_element_1 = require('./stringify_element');
var ng_preboot_1 = require('./ng_preboot');
var lang_1 = require('angular2/src/facade/lang');
var shared_styles_host_1 = require('angular2/src/platform/dom/shared_styles_host');
var core_1 = require('angular2/core');
var router_1 = require('angular2/router');
function waitRouter(appRef) {
    var injector = appRef.injector;
    var router = injector.get(router_1.Router, router_1.Router);
    return Promise.resolve(router && router._currentNavigation)
        .then(function () { return new Promise(function (resolve) { return setTimeout(function () { return resolve(appRef); }); }); });
}
exports.waitRouter = waitRouter;
function renderDocument(documentHtml, componentType, nodeProviders) {
    return node_1.bootstrap(componentType, nodeProviders.concat([
        new core_1.Provider(common_dom_1.DOCUMENT, { useValue: document_1.parseDocument(documentHtml) })
    ]))
        .then(waitRouter)
        .then(function (appRef) {
        var injector = appRef.injector;
        var document = injector.get(common_dom_1.DOCUMENT);
        return document_1.serializeDocument(document);
    });
}
exports.renderDocument = renderDocument;
function renderDocumentWithPreboot(documentHtml, componentType, nodeProviders, prebootConfig) {
    if (prebootConfig === void 0) { prebootConfig = {}; }
    return renderDocument(documentHtml, componentType, nodeProviders)
        .then(function (html) { return ng_preboot_1.createPrebootCode(componentType, prebootConfig).then(function (code) { return html + code; }); });
}
exports.renderDocumentWithPreboot = renderDocumentWithPreboot;
function serializeApplication(element, styles, cache) {
    // serialize all style hosts
    var serializedStyleHosts = styles.length >= 1 ? '<style>' + styles.join('\n') + '</style>' : '';
    // serialize Top Level Component
    var serializedCmp = stringify_element_1.stringifyElement(element);
    // serialize App Data
    var serializedData = lang_1.isBlank(cache) ? '' : '' +
        '<script>' +
        'window.' + 'ngPreloadCache' + ' = ' + JSON.stringify(cache, null, 2) +
        '</script>' +
        '';
    return serializedStyleHosts + serializedCmp + serializedData;
}
exports.serializeApplication = serializeApplication;
function appRefSyncRender(appRef) {
    // grab parse5 html element
    var element = appRef.location.nativeElement;
    // TODO: we need a better way to manage the style host for server/client
    var sharedStylesHost = appRef.injector.get(shared_styles_host_1.SharedStylesHost);
    var styles = sharedStylesHost.getAllStyles();
    var serializedApp = serializeApplication(element, styles);
    return serializedApp;
}
exports.appRefSyncRender = appRefSyncRender;
function applicationToString(appRef) {
    var html = appRefSyncRender(appRef);
    appRef.destroy();
    return html;
}
exports.applicationToString = applicationToString;
function renderToString(componentType, nodeProviders) {
    console.warn('DEPRECATION WARNING: `renderToString` is no longer supported and will be removed in next release.');
    return node_1.bootstrap(componentType, nodeProviders)
        .then(applicationToString);
}
exports.renderToString = renderToString;
function renderToStringWithPreboot(componentType, nodeProviders, prebootConfig) {
    if (prebootConfig === void 0) { prebootConfig = {}; }
    console.warn('DEPRECATION WARNING: `renderToStringWithPreboot` is no longer supported and will be removed in next release.');
    return renderToString(componentType, nodeProviders)
        .then(function (html) { return ng_preboot_1.createPrebootCode(componentType, prebootConfig).then(function (code) { return html + code; }); });
}
exports.renderToStringWithPreboot = renderToStringWithPreboot;
//# sourceMappingURL=render.js.map