"use strict";
var core_1 = require('@angular/core');
var http_1 = require('@angular/http');
var platform_browser_dynamic_1 = require('@angular/platform-browser-dynamic');
var platform_browser_1 = require('@angular/platform-browser');
var prebootClient;
try {
    prebootClient = require('preboot/__build/src/browser/preboot_browser');
    prebootClient = (prebootClient && prebootClient.prebootClient) || prebootClient;
}
catch (e) { }
function _randomChar() {
    return String.fromCharCode(97 + Math.floor(Math.random() * 25));
}
function _appIdRandomProviderFactory() {
    return "" + _randomChar() + _randomChar() + _randomChar();
}
var SharedStylesHost = platform_browser_1.__platform_browser_private__.SharedStylesHost;
exports.UNIVERSAL_CACHE = new core_1.OpaqueToken('UNIVERSAL_CACHE');
exports.AUTO_PREBOOT = new core_1.OpaqueToken('AUTO_PREBOOT');
function universalCacheFactory() {
    var _win = window;
    var CACHE = Object.assign({}, _win.UNIVERSAL_CACHE || {});
    delete _win.UNIVERSAL_CACHE;
    return CACHE;
}
exports.universalCacheFactory = universalCacheFactory;
function appIdFactory() {
    var _win = window;
    var CACHE = _win.UNIVERSAL_CACHE || {};
    var appId = null;
    if (CACHE.APP_ID) {
        appId = CACHE.APP_ID;
    }
    else {
        appId = _appIdRandomProviderFactory();
    }
    return appId;
}
exports.appIdFactory = appIdFactory;
function appBootstrapListenerFactory(autoPreboot) {
    return autoPreboot ? prebootComplete : function () { };
}
exports.appBootstrapListenerFactory = appBootstrapListenerFactory;
function prebootComplete(value) {
    var _win = window;
    if (_win && prebootClient) {
        setTimeout(function () { return prebootClient().complete(); });
    }
    return value;
}
exports.prebootComplete = prebootComplete;
var UniversalModule = (function () {
    function UniversalModule(sharedStylesHost) {
        var domStyles = document.head.querySelectorAll('style');
        var styles = Array.prototype.slice.call(domStyles)
            .filter(function (style) { return (style.innerText || style.textContent).indexOf('_ng') !== -1; })
            .map(function (style) { return (style.innerText || style.textContent); });
        styles.forEach(function (style) {
            sharedStylesHost._stylesSet.add(style);
            sharedStylesHost._styles.push(style);
        });
    }
    UniversalModule.withConfig = function (_config) {
        if (_config === void 0) { _config = {}; }
        var providers = [];
        if (typeof _config.autoPreboot === 'boolean') {
            providers.push({
                provide: exports.AUTO_PREBOOT,
                useValue: _config.autoPreboot,
            });
        }
        return {
            ngModule: UniversalModule,
            providers: providers,
        };
    };
    UniversalModule.decorators = [
        { type: core_1.NgModule, args: [{
                    imports: [],
                    exports: [
                        platform_browser_1.BrowserModule,
                        http_1.HttpModule,
                        http_1.JsonpModule
                    ],
                    providers: [
                        {
                            provide: exports.UNIVERSAL_CACHE,
                            useFactory: universalCacheFactory,
                        },
                        {
                            provide: core_1.APP_ID,
                            useFactory: appIdFactory,
                            deps: []
                        },
                        {
                            provide: exports.AUTO_PREBOOT,
                            useValue: true
                        },
                        {
                            multi: true,
                            provide: core_1.APP_BOOTSTRAP_LISTENER,
                            useFactory: appBootstrapListenerFactory,
                            deps: [exports.AUTO_PREBOOT],
                        },
                    ]
                },] },
    ];
    UniversalModule.ctorParameters = [
        { type: undefined, decorators: [{ type: core_1.Inject, args: [SharedStylesHost,] },] },
    ];
    return UniversalModule;
}());
exports.UniversalModule = UniversalModule;
function platformUniversalDynamic(extraProviders) {
    var platform = core_1.createPlatformFactory(platform_browser_dynamic_1.platformBrowserDynamic, 'universalBrowserDynamic', [])(extraProviders);
    return platform;
}
exports.platformUniversalDynamic = platformUniversalDynamic;
;
//# sourceMappingURL=universal-module.js.map