var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") return Reflect.decorate(decorators, target, key, desc);
    switch (arguments.length) {
        case 2: return decorators.reduceRight(function(o, d) { return (d && d(o)) || o; }, target);
        case 3: return decorators.reduceRight(function(o, d) { return (d && d(target, key)), void 0; }, void 0);
        case 4: return decorators.reduceRight(function(o, d) { return (d && d(target, key, o)) || o; }, desc);
    }
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
import { Directive } from 'angular2/src/core/metadata';
import { Optional, Inject, Host, SkipSelf, forwardRef, Provider } from 'angular2/src/core/di';
import { CONST_EXPR } from 'angular2/src/core/facade/lang';
import { ControlContainer } from './control_container';
import { controlPath } from './shared';
import { Validators, NG_VALIDATORS } from '../validators';
const controlGroupBinding = CONST_EXPR(new Provider(ControlContainer, { useExisting: forwardRef(() => NgControlGroup) }));
/**
 * Creates and binds a control group to a DOM element.
 *
 * This directive can only be used as a child of {@link NgForm} or {@link NgFormModel}.
 *
 * ### Example
 *
 * In this example, we create the credentials and personal control groups.
 * We can work with each group separately: check its validity, get its value, listen to its changes.
 *
 *  ```
 * @Component({
 *      selector: "signup-comp",
 *      directives: [FORM_DIRECTIVES],
 *      template: `
 *              <form #f="form" (submit)='onSignUp(f.value)'>
 *                <div ng-control-group='credentials' #credentials="form">
 *                  Login <input type='text' ng-control='login'>
 *                  Password <input type='password' ng-control='password'>
 *                </div>
 *                <div *ng-if="!credentials.valid">Credentials are invalid</div>
 *
 *                <div ng-control-group='personal'>
 *                  Name <input type='text' ng-control='name'>
 *                </div>
 *                <button type='submit'>Sign Up!</button>
 *              </form>
 *      `})
 * class SignupComp {
 *  onSignUp(value) {
 *    // value === {
 *    //  personal: {name: 'some name'},
 *    //  credentials: {login: 'some login', password: 'some password'}}
 *  }
 * }
 *
 *  ```
 */
export let NgControlGroup = class extends ControlContainer {
    constructor(parent, validators) {
        super();
        this._parent = parent;
        this._validators = validators;
    }
    onInit() { this.formDirective.addControlGroup(this); }
    onDestroy() { this.formDirective.removeControlGroup(this); }
    get control() { return this.formDirective.getControlGroup(this); }
    get path() { return controlPath(this.name, this._parent); }
    get formDirective() { return this._parent.formDirective; }
    get validator() { return Validators.compose(this._validators); }
};
NgControlGroup = __decorate([
    Directive({
        selector: '[ng-control-group]',
        bindings: [controlGroupBinding],
        inputs: ['name: ng-control-group'],
        exportAs: 'form'
    }),
    __param(0, Host()),
    __param(0, SkipSelf()),
    __param(1, Optional()),
    __param(1, Inject(NG_VALIDATORS)), 
    __metadata('design:paramtypes', [ControlContainer, Array])
], NgControlGroup);
//# sourceMappingURL=ng_control_group.js.map