export var LifecycleHooks;
(function (LifecycleHooks) {
    LifecycleHooks[LifecycleHooks["OnInit"] = 0] = "OnInit";
    LifecycleHooks[LifecycleHooks["OnDestroy"] = 1] = "OnDestroy";
    LifecycleHooks[LifecycleHooks["DoCheck"] = 2] = "DoCheck";
    LifecycleHooks[LifecycleHooks["OnChanges"] = 3] = "OnChanges";
    LifecycleHooks[LifecycleHooks["AfterContentInit"] = 4] = "AfterContentInit";
    LifecycleHooks[LifecycleHooks["AfterContentChecked"] = 5] = "AfterContentChecked";
    LifecycleHooks[LifecycleHooks["AfterViewInit"] = 6] = "AfterViewInit";
    LifecycleHooks[LifecycleHooks["AfterViewChecked"] = 7] = "AfterViewChecked";
})(LifecycleHooks || (LifecycleHooks = {}));
/**
 * @internal
 */
export var LIFECYCLE_HOOKS_VALUES = [
    LifecycleHooks.OnInit,
    LifecycleHooks.OnDestroy,
    LifecycleHooks.DoCheck,
    LifecycleHooks.OnChanges,
    LifecycleHooks.AfterContentInit,
    LifecycleHooks.AfterContentChecked,
    LifecycleHooks.AfterViewInit,
    LifecycleHooks.AfterViewChecked
];
//# sourceMappingURL=data:application/json;base64,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