var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") return Reflect.decorate(decorators, target, key, desc);
    switch (arguments.length) {
        case 2: return decorators.reduceRight(function(o, d) { return (d && d(o)) || o; }, target);
        case 3: return decorators.reduceRight(function(o, d) { return (d && d(target, key)), void 0; }, void 0);
        case 4: return decorators.reduceRight(function(o, d) { return (d && d(target, key, o)) || o; }, desc);
    }
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
import { Inject, Injectable, forwardRef } from 'angular2/src/core/di';
import { isPresent, isBlank } from 'angular2/src/facade/lang';
import { BaseException } from 'angular2/src/facade/exceptions';
import * as viewModule from './view';
import { internalView, internalProtoView } from './view_ref';
import { Renderer } from 'angular2/src/core/render/api';
import { AppViewManagerUtils } from './view_manager_utils';
import { AppViewPool } from './view_pool';
import { AppViewListener } from './view_listener';
import { wtfCreateScope, wtfLeave } from '../profile/profile';
import { ProtoViewFactory } from './proto_view_factory';
/**
 * Service exposing low level API for creating, moving and destroying Views.
 *
 * Most applications should use higher-level abstractions like {@link DynamicComponentLoader} and
 * {@link ViewContainerRef} instead.
 */
export class AppViewManager {
    /**
     * Returns the {@link ElementRef} that makes up the specified Host View.
     */
    getHostElement(hostViewRef) {
        var hostView = internalView(hostViewRef);
        if (hostView.proto.type !== viewModule.ViewType.HOST) {
            throw new BaseException('This operation is only allowed on host views');
        }
        return hostView.elementRefs[hostView.elementOffset];
    }
}
export let AppViewManager_ = class extends AppViewManager {
    constructor(_viewPool, _viewListener, _utils, _renderer, _protoViewFactory) {
        super();
        this._viewPool = _viewPool;
        this._viewListener = _viewListener;
        this._utils = _utils;
        this._renderer = _renderer;
        /** @internal */
        this._createRootHostViewScope = wtfCreateScope('AppViewManager#createRootHostView()');
        /** @internal */
        this._destroyRootHostViewScope = wtfCreateScope('AppViewManager#destroyRootHostView()');
        /** @internal */
        this._createEmbeddedViewInContainerScope = wtfCreateScope('AppViewManager#createEmbeddedViewInContainer()');
        /** @internal */
        this._createHostViewInContainerScope = wtfCreateScope('AppViewManager#createHostViewInContainer()');
        /** @internal */
        this._destroyViewInContainerScope = wtfCreateScope('AppViewMananger#destroyViewInContainer()');
        /** @internal */
        this._attachViewInContainerScope = wtfCreateScope('AppViewMananger#attachViewInContainer()');
        /** @internal */
        this._detachViewInContainerScope = wtfCreateScope('AppViewMananger#detachViewInContainer()');
        this._protoViewFactory = _protoViewFactory;
    }
    getViewContainer(location) {
        var hostView = internalView(location.parentView);
        return hostView.elementInjectors[location.boundElementIndex]
            .getViewContainerRef();
    }
    getNamedElementInComponentView(hostLocation, variableName) {
        var hostView = internalView(hostLocation.parentView);
        var boundElementIndex = hostLocation.boundElementIndex;
        var componentView = hostView.getNestedView(boundElementIndex);
        if (isBlank(componentView)) {
            throw new BaseException(`There is no component directive at element ${boundElementIndex}`);
        }
        var binderIdx = componentView.proto.variableLocations.get(variableName);
        if (isBlank(binderIdx)) {
            throw new BaseException(`Could not find variable ${variableName}`);
        }
        return componentView.elementRefs[componentView.elementOffset + binderIdx];
    }
    getComponent(hostLocation) {
        var hostView = internalView(hostLocation.parentView);
        var boundElementIndex = hostLocation.boundElementIndex;
        return this._utils.getComponentInstance(hostView, boundElementIndex);
    }
    createRootHostView(hostProtoViewRef, overrideSelector, injector) {
        var s = this._createRootHostViewScope();
        var hostProtoView = internalProtoView(hostProtoViewRef);
        this._protoViewFactory.initializeProtoViewIfNeeded(hostProtoView);
        var hostElementSelector = overrideSelector;
        if (isBlank(hostElementSelector)) {
            hostElementSelector = hostProtoView.elementBinders[0].componentDirective.metadata.selector;
        }
        var renderViewWithFragments = this._renderer.createRootHostView(hostProtoView.render, hostProtoView.mergeInfo.embeddedViewCount + 1, hostElementSelector);
        var hostView = this._createMainView(hostProtoView, renderViewWithFragments);
        this._renderer.hydrateView(hostView.render);
        this._utils.hydrateRootHostView(hostView, injector);
        return wtfLeave(s, hostView.ref);
    }
    destroyRootHostView(hostViewRef) {
        // Note: Don't put the hostView into the view pool
        // as it is depending on the element for which it was created.
        var s = this._destroyRootHostViewScope();
        var hostView = internalView(hostViewRef);
        this._renderer.detachFragment(hostView.renderFragment);
        this._renderer.dehydrateView(hostView.render);
        this._viewDehydrateRecurse(hostView);
        this._viewListener.onViewDestroyed(hostView);
        this._renderer.destroyView(hostView.render);
        wtfLeave(s);
    }
    createEmbeddedViewInContainer(viewContainerLocation, index, templateRef) {
        var s = this._createEmbeddedViewInContainerScope();
        var protoView = internalProtoView(templateRef.protoViewRef);
        if (protoView.type !== viewModule.ViewType.EMBEDDED) {
            throw new BaseException('This method can only be called with embedded ProtoViews!');
        }
        this._protoViewFactory.initializeProtoViewIfNeeded(protoView);
        return wtfLeave(s, this._createViewInContainer(viewContainerLocation, index, protoView, templateRef.elementRef, null));
    }
    createHostViewInContainer(viewContainerLocation, index, protoViewRef, imperativelyCreatedInjector) {
        var s = this._createHostViewInContainerScope();
        var protoView = internalProtoView(protoViewRef);
        if (protoView.type !== viewModule.ViewType.HOST) {
            throw new BaseException('This method can only be called with host ProtoViews!');
        }
        this._protoViewFactory.initializeProtoViewIfNeeded(protoView);
        return wtfLeave(s, this._createViewInContainer(viewContainerLocation, index, protoView, viewContainerLocation, imperativelyCreatedInjector));
    }
    /**
     *
     * See {@link AppViewManager#destroyViewInContainer}.
     * @internal
     */
    _createViewInContainer(viewContainerLocation, index, protoView, context, imperativelyCreatedInjector) {
        var parentView = internalView(viewContainerLocation.parentView);
        var boundElementIndex = viewContainerLocation.boundElementIndex;
        var contextView = internalView(context.parentView);
        var contextBoundElementIndex = context.boundElementIndex;
        var embeddedFragmentView = contextView.getNestedView(contextBoundElementIndex);
        var view;
        if (protoView.type === viewModule.ViewType.EMBEDDED && isPresent(embeddedFragmentView) &&
            !embeddedFragmentView.hydrated()) {
            // Case 1: instantiate the first view of a template that has been merged into a parent
            view = embeddedFragmentView;
            this._attachRenderView(parentView, boundElementIndex, index, view);
        }
        else {
            // Case 2: instantiate another copy of the template or a host ProtoView.
            // This is a separate case
            // as we only inline one copy of the template into the parent view.
            view = this._createPooledView(protoView);
            this._attachRenderView(parentView, boundElementIndex, index, view);
            this._renderer.hydrateView(view.render);
        }
        this._utils.attachViewInContainer(parentView, boundElementIndex, contextView, contextBoundElementIndex, index, view);
        try {
            this._utils.hydrateViewInContainer(parentView, boundElementIndex, contextView, contextBoundElementIndex, index, imperativelyCreatedInjector);
        }
        catch (e) {
            this._utils.detachViewInContainer(parentView, boundElementIndex, index);
            throw e;
        }
        return view.ref;
    }
    /** @internal */
    _attachRenderView(parentView, boundElementIndex, index, view) {
        var elementRef = parentView.elementRefs[boundElementIndex];
        if (index === 0) {
            this._renderer.attachFragmentAfterElement(elementRef, view.renderFragment);
        }
        else {
            var prevView = parentView.viewContainers[boundElementIndex].views[index - 1];
            this._renderer.attachFragmentAfterFragment(prevView.renderFragment, view.renderFragment);
        }
    }
    destroyViewInContainer(viewContainerLocation, index) {
        var s = this._destroyViewInContainerScope();
        var parentView = internalView(viewContainerLocation.parentView);
        var boundElementIndex = viewContainerLocation.boundElementIndex;
        this._destroyViewInContainer(parentView, boundElementIndex, index);
        wtfLeave(s);
    }
    // TODO(i): refactor detachViewInContainer+attachViewInContainer to moveViewInContainer
    attachViewInContainer(viewContainerLocation, index, viewRef) {
        var s = this._attachViewInContainerScope();
        var view = internalView(viewRef);
        var parentView = internalView(viewContainerLocation.parentView);
        var boundElementIndex = viewContainerLocation.boundElementIndex;
        // TODO(tbosch): the public methods attachViewInContainer/detachViewInContainer
        // are used for moving elements without the same container.
        // We will change this into an atomic `move` operation, which should preserve the
        // previous parent injector (see https://github.com/angular/angular/issues/1377).
        // Right now we are destroying any special
        // context view that might have been used.
        this._utils.attachViewInContainer(parentView, boundElementIndex, null, null, index, view);
        this._attachRenderView(parentView, boundElementIndex, index, view);
        return wtfLeave(s, viewRef);
    }
    // TODO(i): refactor detachViewInContainer+attachViewInContainer to moveViewInContainer
    detachViewInContainer(viewContainerLocation, index) {
        var s = this._detachViewInContainerScope();
        var parentView = internalView(viewContainerLocation.parentView);
        var boundElementIndex = viewContainerLocation.boundElementIndex;
        var viewContainer = parentView.viewContainers[boundElementIndex];
        var view = viewContainer.views[index];
        this._utils.detachViewInContainer(parentView, boundElementIndex, index);
        this._renderer.detachFragment(view.renderFragment);
        return wtfLeave(s, view.ref);
    }
    /** @internal */
    _createMainView(protoView, renderViewWithFragments) {
        var mergedParentView = this._utils.createView(protoView, renderViewWithFragments, this, this._renderer);
        this._renderer.setEventDispatcher(mergedParentView.render, mergedParentView);
        this._viewListener.onViewCreated(mergedParentView);
        return mergedParentView;
    }
    /** @internal */
    _createPooledView(protoView) {
        var view = this._viewPool.getView(protoView);
        if (isBlank(view)) {
            view = this._createMainView(protoView, this._renderer.createView(protoView.render, protoView.mergeInfo.embeddedViewCount + 1));
        }
        return view;
    }
    /** @internal */
    _destroyPooledView(view) {
        var wasReturned = this._viewPool.returnView(view);
        if (!wasReturned) {
            this._viewListener.onViewDestroyed(view);
            this._renderer.destroyView(view.render);
        }
    }
    /** @internal */
    _destroyViewInContainer(parentView, boundElementIndex, index) {
        var viewContainer = parentView.viewContainers[boundElementIndex];
        var view = viewContainer.views[index];
        this._viewDehydrateRecurse(view);
        this._utils.detachViewInContainer(parentView, boundElementIndex, index);
        if (view.viewOffset > 0) {
            // Case 1: a view that is part of another view.
            // Just detach the fragment
            this._renderer.detachFragment(view.renderFragment);
        }
        else {
            // Case 2: a view that is not part of another view.
            // dehydrate and destroy it.
            this._renderer.dehydrateView(view.render);
            this._renderer.detachFragment(view.renderFragment);
            this._destroyPooledView(view);
        }
    }
    /** @internal */
    _viewDehydrateRecurse(view) {
        if (view.hydrated()) {
            this._utils.dehydrateView(view);
        }
        var viewContainers = view.viewContainers;
        var startViewOffset = view.viewOffset;
        var endViewOffset = view.viewOffset + view.proto.mergeInfo.viewCount - 1;
        var elementOffset = view.elementOffset;
        for (var viewIdx = startViewOffset; viewIdx <= endViewOffset; viewIdx++) {
            var currView = view.views[viewIdx];
            for (var binderIdx = 0; binderIdx < currView.proto.elementBinders.length; binderIdx++, elementOffset++) {
                var vc = viewContainers[elementOffset];
                if (isPresent(vc)) {
                    for (var j = vc.views.length - 1; j >= 0; j--) {
                        this._destroyViewInContainer(currView, elementOffset, j);
                    }
                }
            }
        }
    }
};
AppViewManager_ = __decorate([
    Injectable(),
    __param(4, Inject(forwardRef(() => ProtoViewFactory))), 
    __metadata('design:paramtypes', [AppViewPool, AppViewListener, AppViewManagerUtils, Renderer, Object])
], AppViewManager_);
//# sourceMappingURL=data:application/json;base64,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